/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.location;

import com.sun.xacml.Indenter;
import com.sun.xacml.location.LocationLogical;
import com.sun.xacml.location.LocationNode;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import intervalTree.IntervalTree;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class LocationType
extends LocationNode {
    private boolean isTop = false;
    private static LocationType topInstance = null;
    private IntervalTree<LocationLogical> associatedLLocsX = new IntervalTree();
    private IntervalTree<LocationLogical> associatedLLocsY = new IntervalTree();

    public LocationType(String name, Map<String, LocationNode> links) {
        super(name, links);
    }

    public LocationType(String name) {
        super(name);
    }

    public List<LocationLogical> getLocationsContaining(Point p) {
        HashSet<LocationLogical> llocsForX = new HashSet<LocationLogical>(this.associatedLLocsX.get(p.getX()));
        HashSet<LocationLogical> llocsForY = new HashSet<LocationLogical>(this.associatedLLocsY.get(p.getY()));
        LinkedList<LocationLogical> result = new LinkedList<LocationLogical>();
        for (LocationLogical ll : llocsForY) {
            if (!llocsForX.contains(ll) || !ll.getGeometry().contains((Geometry)p)) continue;
            result.add(ll);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LocationType getTopInstance() {
        if (topInstance != null) return topInstance;
        Class<LocationType> clazz = LocationType.class;
        synchronized (LocationType.class) {
            if (topInstance != null) return topInstance;
            topInstance = new LocationType("top");
            LocationType.topInstance.isTop = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return topInstance;
        }
    }

    public boolean isTopInstance() {
        return this.isTop;
    }

    public void addAssociationToLogicalLoc(LocationLogical ll) {
        Envelope env = ll.getGeometry().getEnvelopeInternal();
        this.associatedLLocsX.addInterval(env.getMinX(), env.getMaxX(), ll);
        this.associatedLLocsY.addInterval(env.getMinY(), env.getMaxY(), ll);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        LocationType other = (LocationType)obj;
        return this.name == other.name || this.name != null && this.name.equals(other.name);
    }

    public int hashCode() {
        int hash = 8;
        hash = 31 * hash + (this.name == null ? 0 : this.name.hashCode());
        return hash;
    }

    public void encodeOnlyName(OutputStream output, Indenter ind) {
        PrintStream out = new PrintStream(output);
        out.println(String.valueOf(ind.makeString()) + "<LocationType>");
        ind.in();
        out.println(String.valueOf(ind.makeString()) + "<Name>" + this.name + "</Name>");
        ind.out();
        out.println(String.valueOf(ind.makeString()) + "</LocationType>");
    }

    public String toString() {
        return this.name == null ? "" : "LocationType name=" + this.name;
    }
}

