/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.support;

import com.sun.xacml.ConfigurationStore;
import com.sun.xacml.Indenter;
import com.sun.xacml.MyBasicEvaluationCtx;
import com.sun.xacml.PDP;
import com.sun.xacml.PDPConfig;
import com.sun.xacml.attr.AttributeFactory;
import com.sun.xacml.attr.AttributeFactoryProxy;
import com.sun.xacml.attr.AttributeValue;
import com.sun.xacml.attr.MyAttributeFactory;
import com.sun.xacml.cond.FunctionFactory;
import com.sun.xacml.cond.MyFunctionFactoryProxy;
import com.sun.xacml.ctx.Attribute;
import com.sun.xacml.ctx.EnablingResult;
import com.sun.xacml.ctx.RequestCtx;
import com.sun.xacml.ctx.ResponseCtx;
import com.sun.xacml.ctx.Result;
import com.sun.xacml.ctx.Subject;
import com.sun.xacml.finder.AttributeFinder;
import com.sun.xacml.finder.AttributeFinderModule;
import com.sun.xacml.finder.PolicyFinder;
import com.sun.xacml.finder.PolicyFinderModule;
import com.sun.xacml.finder.impl.CurrentEnvModule;
import com.sun.xacml.finder.impl.RoleParameterModule;
import com.sun.xacml.finder.impl.SelectorModule;
import com.sun.xacml.support.EnablingPDP;
import com.sun.xacml.support.finder.StaticPolicyFinderModule;
import com.sun.xacml.support.finder.StaticRefPolicyFinderModule;
import com.sun.xacml.support.finder.URLPolicyFinderModule;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class AccessPDP {
    private PDP pdp = null;
    private EnablingPDP enablingPDP = null;
    private String name;
    private AttributeFinder attrFinder;
    private Logger log = Logger.getLogger(AccessPDP.class);

    public AccessPDP(EnablingPDP enPDP) throws Exception {
        ConfigurationStore store = new ConfigurationStore();
        store.useDefaultFactories();
        this.pdp = new PDP(store.getDefaultPDPConfig());
        this.enablingPDP = enPDP;
    }

    public AccessPDP(String pdpName, String[] policies, String[] refPolicies, EnablingPDP enPDP) throws Exception {
        AttributeFactoryProxy attrProxy = new AttributeFactoryProxy(){

            @Override
            public AttributeFactory getFactory() {
                return MyAttributeFactory.getFactory();
            }
        };
        AttributeFactory.setDefaultFactory(attrProxy);
        MyFunctionFactoryProxy funcProxy = MyFunctionFactoryProxy.getNewProxy();
        FunctionFactory.setDefaultFactory(funcProxy);
        List<String> policyList = Arrays.asList(policies);
        List<String> refPolicyList = refPolicies != null ? Arrays.asList(refPolicies) : new LinkedList<String>();
        StaticPolicyFinderModule staticModule = new StaticPolicyFinderModule("urn:oasis:names:tc:xacml:1.0:policy-combining-algorithm:permit-overrides", policyList);
        StaticRefPolicyFinderModule staticRefModule = new StaticRefPolicyFinderModule(refPolicyList);
        URLPolicyFinderModule urlModule = new URLPolicyFinderModule();
        PolicyFinder policyFinder = new PolicyFinder();
        HashSet<PolicyFinderModule> policyModules = new HashSet<PolicyFinderModule>();
        policyModules.add(staticModule);
        policyModules.add(staticRefModule);
        policyModules.add(urlModule);
        policyFinder.setModules(policyModules);
        CurrentEnvModule envAttributeModule = new CurrentEnvModule();
        SelectorModule selectorAttributeModule = new SelectorModule();
        RoleParameterModule roleParameterModule = new RoleParameterModule();
        AttributeFinder attributeFinder = new AttributeFinder();
        ArrayList<AttributeFinderModule> attributeModules = new ArrayList<AttributeFinderModule>();
        attributeModules.add(envAttributeModule);
        attributeModules.add(selectorAttributeModule);
        attributeModules.add(roleParameterModule);
        attributeFinder.setModules(attributeModules);
        this.attrFinder = attributeFinder;
        this.pdp = new PDP(new PDPConfig(attributeFinder, policyFinder, null));
        this.name = pdpName;
        this.enablingPDP = enPDP;
    }

    public ResponseCtx evaluate(String requestFile) throws Exception {
        RequestCtx request = RequestCtx.getInstance(new FileInputStream(requestFile));
        RequestCtx enablingRequest = this.buildEnablingRequest(request);
        ResponseCtx enablingResponse = this.enablingPDP.evaluate(enablingRequest);
        Iterator resIt = enablingResponse.getResults().iterator();
        Result enablingResult = null;
        while (resIt.hasNext()) {
            Object currRes = resIt.next();
            if (!(currRes instanceof EnablingResult)) continue;
            enablingResult = (EnablingResult)currRes;
        }
        if (enablingResult == null) {
            throw new Exception("No enabling result received");
        }
        if (enablingResult.getDecision() != 0) {
            return enablingResponse;
        }
        MyBasicEvaluationCtx requestContext = new MyBasicEvaluationCtx(request, this.attrFinder, ((EnablingResult)enablingResult).getEvents(), ((EnablingResult)enablingResult).getLocations());
        return this.pdp.evaluate(requestContext);
    }

    public ResponseCtx evaluate(RequestCtx request) throws Exception {
        RequestCtx enablingRequest = this.buildEnablingRequest(request);
        ByteArrayOutputStream streamOut = new ByteArrayOutputStream();
        enablingRequest.encode(streamOut);
        this.log.debug((Object)"Generated enabling request:");
        this.log.debug((Object)streamOut);
        ResponseCtx enablingResponse = this.enablingPDP.evaluate(enablingRequest);
        Set enResults = enablingResponse.getResults();
        if (enResults.size() > 1) {
            this.log.warn((Object)"More than 1 result received in the enabling response!");
        }
        Result result = (Result)enResults.iterator().next();
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        result.encode(stream);
        this.log.debug((Object)"Enabling response received:");
        this.log.debug((Object)stream);
        this.log.info((Object)("Enabling decision --> " + Result.DECISIONS[result.getDecision()] + " for: " + result.getResource()));
        if (result.getDecision() != 0) {
            return enablingResponse;
        }
        EnablingResult enablingResult = null;
        if (result instanceof EnablingResult) {
            enablingResult = (EnablingResult)result;
        }
        if (enablingResult == null) {
            this.log.fatal((Object)"EnablingResult instance not found in the enabling response.");
            System.exit(-1);
        }
        MyBasicEvaluationCtx requestContext = new MyBasicEvaluationCtx(request, this.attrFinder, enablingResult.getEvents(), enablingResult.getLocations());
        return this.pdp.evaluate(requestContext);
    }

    private Attribute findAttributeInContext(Set group, URI attrId) {
        for (Subject currEl : group) {
            for (Attribute currAttr : currEl.getAttributes()) {
                if (currAttr.getId().compareTo(attrId) != 0) continue;
                return currAttr;
            }
        }
        return null;
    }

    private RequestCtx buildEnablingRequest(RequestCtx request) throws Exception {
        HashSet<Subject> subjects = new HashSet<Subject>();
        AttributeFactory attrF = AttributeFactory.getInstance();
        URI stringAttrIdURI = new URI("http://www.w3.org/2001/XMLSchema#string");
        AttributeValue recipientSubjID = attrF.createValue(stringAttrIdURI, this.name);
        HashSet<Attribute> recipient = new HashSet<Attribute>();
        recipient.add(new Attribute(new URI("urn:oasis:names:tc:xacml:1.0:subject-category:subject-id"), null, null, recipientSubjID));
        subjects.add(new Subject(new URI("urn:oasis:names:tc:xacml:1.0:subject-category:recipient-subject"), recipient));
        HashSet<Attribute> subject = new HashSet<Attribute>();
        AttributeValue userName = this.findAttributeInContext(request.getSubjects(), new URI("urn:oasis:names:tc:xacml:1.0:subject:subject-id")).getValue();
        subject.add(new Attribute(new URI("urn:oasis:names:tc:xacml:1.0:subject-category:subject-id"), null, null, userName));
        Attribute userPos = this.findAttributeInContext(request.getSubjects(), new URI("urn:my:subject:position-coord"));
        subject.add(userPos);
        Attribute requestTime = this.findAttributeInContext(request.getSubjects(), new URI("urn:oasis:names:tc:xacml:1.0:subject:request-time"));
        subject.add(requestTime);
        subjects.add(new Subject(null, subject));
        HashSet<Attribute> resource = new HashSet<Attribute>();
        AttributeValue roleAttr = this.findAttributeInContext(request.getSubjects(), new URI("urn:oasis:names:tc:xacml:2.0:subject:role")).getValue();
        resource.add(new Attribute(new URI("urn:oasis:names:tc:xacml:1.0:resource:resource-id"), null, null, roleAttr));
        HashSet<Attribute> action = new HashSet<Attribute>();
        AttributeValue actionID = attrF.createValue(stringAttrIdURI, "enableRole");
        action.add(new Attribute(new URI("urn:oasis:names:tc:xacml:1.0:action:action-id"), null, null, actionID));
        HashSet environment = new HashSet();
        return new RequestCtx(subjects, resource, action, environment);
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.out.println("Usage: -config <request>");
            System.out.println("       <request> <policy> [policies] -ref <policy> [policies]");
            System.exit(1);
        }
        AccessPDP accessPDP = null;
        String requestFile = null;
        String[] enablingPolicies = new String[]{"/home/davide/enablingPolicy"};
        EnablingPDP enablingPDP = new EnablingPDP(enablingPolicies);
        if (args[0].equals("-config")) {
            requestFile = args[1];
            accessPDP = new AccessPDP(enablingPDP);
        } else {
            ArrayList<String> policies = new ArrayList<String>();
            ArrayList<String> refPolicies = new ArrayList<String>();
            int i = 1;
            i = 1;
            while (i < args.length) {
                if (args[i].equals("-ref") && args.length == i + 1) {
                    System.out.println("Usage: -config <request>");
                    System.out.println("       <request> <policy> [policies] -ref <policy> [policies]");
                    System.exit(1);
                } else if (args[i].equals("-ref")) break;
                policies.add(args[i]);
                ++i;
            }
            while (++i < args.length) {
                refPolicies.add(args[i]);
            }
            requestFile = args[0];
            String[] policyFiles = new String[policies.size()];
            policyFiles = policies.toArray(policyFiles);
            String[] refPolicyFiles = null;
            if (refPolicies.size() > 0) {
                refPolicyFiles = new String[refPolicies.size()];
                refPolicyFiles = refPolicies.toArray(refPolicyFiles);
            }
            accessPDP = new AccessPDP("accessPdp", policyFiles, refPolicyFiles, enablingPDP);
        }
        ResponseCtx response = accessPDP.evaluate(requestFile);
        response.encode(System.out, new Indenter());
    }
}

