/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.support;

import com.sun.xacml.ConfigurationStore;
import com.sun.xacml.Indenter;
import com.sun.xacml.PDP;
import com.sun.xacml.PDPConfig;
import com.sun.xacml.ParsingException;
import com.sun.xacml.attr.AttributeFactory;
import com.sun.xacml.attr.AttributeFactoryProxy;
import com.sun.xacml.attr.MyAttributeFactory;
import com.sun.xacml.combine.CombiningAlgFactory;
import com.sun.xacml.combine.CombiningAlgFactoryProxy;
import com.sun.xacml.combine.MyCombiningAlgFactory;
import com.sun.xacml.cond.FunctionFactory;
import com.sun.xacml.cond.MyFunctionFactoryProxy;
import com.sun.xacml.ctx.RequestCtx;
import com.sun.xacml.ctx.ResponseCtx;
import com.sun.xacml.event.EventGenericProxy;
import com.sun.xacml.event.EventHandler;
import com.sun.xacml.finder.AttributeFinder;
import com.sun.xacml.finder.AttributeFinderModule;
import com.sun.xacml.finder.PolicyFinder;
import com.sun.xacml.finder.PolicyFinderModule;
import com.sun.xacml.finder.impl.CurrentEnvModule;
import com.sun.xacml.finder.impl.SelectorModule;
import com.sun.xacml.location.LocationHandler;
import com.sun.xacml.support.finder.StaticPolicyFinderModule;
import com.sun.xacml.support.finder.StaticRefPolicyFinderModule;
import com.sun.xacml.support.finder.URLPolicyFinderModule;
import com.vividsolutions.jts.geom.Coordinate;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class EnablingPDP {
    private PDP pdp = null;

    public EnablingPDP() throws Exception {
        ConfigurationStore store = new ConfigurationStore();
        store.useDefaultFactories();
        this.pdp = new PDP(store.getDefaultPDPConfig());
    }

    public EnablingPDP(String[] policies) throws Exception {
        AttributeFactoryProxy attrProxy = new AttributeFactoryProxy(){

            @Override
            public AttributeFactory getFactory() {
                return MyAttributeFactory.getFactory();
            }
        };
        AttributeFactory.setDefaultFactory(attrProxy);
        MyFunctionFactoryProxy funcProxy = MyFunctionFactoryProxy.getNewProxy();
        FunctionFactory.setDefaultFactory(funcProxy);
        CombiningAlgFactoryProxy algProxy = new CombiningAlgFactoryProxy(){

            @Override
            public CombiningAlgFactory getFactory() {
                return MyCombiningAlgFactory.getFactory();
            }
        };
        CombiningAlgFactory.setDefaultFactory(algProxy);
        List<String> policyList = Arrays.asList(policies);
        StaticPolicyFinderModule staticModule = new StaticPolicyFinderModule("urn:oasis:names:tc:xacml:1.0:policy-combining-algorithm:permit-overrides", policyList);
        StaticRefPolicyFinderModule staticRefModule = new StaticRefPolicyFinderModule(policyList);
        URLPolicyFinderModule urlModule = new URLPolicyFinderModule();
        PolicyFinder policyFinder = new PolicyFinder();
        HashSet<PolicyFinderModule> policyModules = new HashSet<PolicyFinderModule>();
        policyModules.add(staticModule);
        policyModules.add(staticRefModule);
        policyModules.add(urlModule);
        policyFinder.setModules(policyModules);
        CurrentEnvModule envAttributeModule = new CurrentEnvModule();
        SelectorModule selectorAttributeModule = new SelectorModule();
        AttributeFinder attributeFinder = new AttributeFinder();
        ArrayList<AttributeFinderModule> attributeModules = new ArrayList<AttributeFinderModule>();
        attributeModules.add(envAttributeModule);
        attributeModules.add(selectorAttributeModule);
        attributeFinder.setModules(attributeModules);
        this.pdp = new PDP(new PDPConfig(attributeFinder, policyFinder, null));
    }

    public ResponseCtx evaluate(String requestFile) throws IOException, ParsingException {
        RequestCtx request = RequestCtx.getInstance(new FileInputStream(requestFile));
        return this.pdp.evaluate(request);
    }

    public ResponseCtx evaluate(RequestCtx requestCtx) {
        return this.pdp.evaluate(requestCtx);
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.out.println("Usage: -config <request>");
            System.out.println("       <request> <policy> [policies]");
            System.exit(1);
        }
        LocationHandler lh = LocationHandler.getInstance(0);
        lh.addLocationType("lt1");
        lh.addLocationType("lt2");
        lh.addLocationType("lt3");
        String[] t1subs = new String[]{"lt3"};
        lh.addTypeRelation("lt1", t1subs);
        Coordinate[] c1 = new Coordinate[]{new Coordinate(0.0, 0.0), new Coordinate(10.0, 0.0), new Coordinate(10.0, 4.0), new Coordinate(0.0, 4.0), new Coordinate(0.0, 0.0)};
        lh.createLogicalPolygon("ll1", "lt1", c1, null);
        Coordinate[] c2 = new Coordinate[]{new Coordinate(1.0, 2.0), new Coordinate(9.0, 2.0), new Coordinate(9.0, 8.0), new Coordinate(1.0, 2.0)};
        lh.createLogicalPolygon("ll2", "lt2", c2, null);
        Coordinate[] c3 = new Coordinate[]{new Coordinate(5.0, 0.0), new Coordinate(8.0, 0.0), new Coordinate(8.0, 4.0), new Coordinate(5.0, 4.0), new Coordinate(5.0, 0.0)};
        lh.createLogicalPolygon("ll3", "lt3", c3, null);
        EventHandler eh = EventHandler.getInstance();
        eh.getEventFactory().addEventType("generic", new EventGenericProxy());
        List param1 = EventGenericProxy.constructParameterList(0, "chirurgoInSala", null, null, new Coordinate(6.0, 1.0));
        eh.createEvent("generic", param1);
        EnablingPDP enablingPDP = null;
        String requestFile = null;
        if (args[0].equals("-config")) {
            requestFile = args[1];
            enablingPDP = new EnablingPDP();
        } else {
            requestFile = args[0];
            String[] policyFiles = new String[args.length - 1];
            int i = 1;
            while (i < args.length) {
                policyFiles[i - 1] = args[i];
                ++i;
            }
            enablingPDP = new EnablingPDP(policyFiles);
        }
        ResponseCtx response = enablingPDP.evaluate(requestFile);
        response.encode(System.out, new Indenter());
    }
}

