/*
 * Decompiled with CFR 0.152.
 */
package intervalTree;

public class Interval<Type>
implements Comparable<Interval<Type>> {
    private double start;
    private double end;
    private Type data;

    public Interval(double start, double end, Type data) {
        this.start = start;
        this.end = end;
        this.data = data;
    }

    public double getStart() {
        return this.start;
    }

    public void setStart(double start) {
        this.start = start;
    }

    public double getEnd() {
        return this.end;
    }

    public void setEnd(double end) {
        this.end = end;
    }

    public Type getData() {
        return this.data;
    }

    public void setData(Type data) {
        this.data = data;
    }

    public boolean contains(double time) {
        return time < this.end && time > this.start;
    }

    public boolean contains(Interval<?> other) {
        return other.getStart() > this.start && other.getEnd() < this.end;
    }

    public boolean intersects(Interval<?> other) {
        return other.getEnd() > this.start && other.getStart() < this.end;
    }

    @Override
    public int compareTo(Interval<Type> other) {
        if (this.start < other.getStart()) {
            return -1;
        }
        if (this.start > other.getStart()) {
            return 1;
        }
        if (this.end < other.getEnd()) {
            return -1;
        }
        if (this.end > other.getEnd()) {
            return 1;
        }
        return 0;
    }
}

