/*
 * Decompiled with CFR 0.152.
 */
package intervalTree;

import intervalTree.Interval;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class IntervalNode<Type> {
    private SortedMap<Interval<Type>, List<Interval<Type>>> intervals = new TreeMap<Interval<Type>, List<Interval<Type>>>();
    private double center;
    private IntervalNode<Type> leftNode;
    private IntervalNode<Type> rightNode;

    public IntervalNode() {
        this.center = 0.0;
        this.leftNode = null;
        this.rightNode = null;
    }

    public IntervalNode(List<Interval<Type>> intervalList) {
        double median;
        TreeSet<Double> endpoints = new TreeSet<Double>();
        for (Interval<Type> interval : intervalList) {
            endpoints.add(interval.getStart());
            endpoints.add(interval.getEnd());
        }
        this.center = median = this.getMedian(endpoints).doubleValue();
        ArrayList<Interval<Type>> left = new ArrayList<Interval<Type>>();
        ArrayList<Interval<Type>> right = new ArrayList<Interval<Type>>();
        for (Interval<Type> interval : intervalList) {
            if (interval.getEnd() < median) {
                left.add(interval);
                continue;
            }
            if (interval.getStart() > median) {
                right.add(interval);
                continue;
            }
            ArrayList<Interval<Type>> posting = (ArrayList<Interval<Type>>)this.intervals.get(interval);
            if (posting == null) {
                posting = new ArrayList<Interval<Type>>();
                this.intervals.put(interval, posting);
            }
            posting.add(interval);
        }
        if (left.size() > 0) {
            this.leftNode = new IntervalNode<Type>(left);
        }
        if (right.size() > 0) {
            this.rightNode = new IntervalNode<Type>(right);
        }
    }

    public List<Interval<Type>> stab(double time) {
        ArrayList<Interval<Type>> result = new ArrayList<Interval<Type>>();
        for (Map.Entry<Interval<Type>, List<Interval<Type>>> entry : this.intervals.entrySet()) {
            if (entry.getKey().contains(time)) {
                for (Interval<Type> interval : entry.getValue()) {
                    result.add(interval);
                }
                continue;
            }
            if (entry.getKey().getStart() > time) break;
        }
        if (time < this.center && this.leftNode != null) {
            result.addAll(this.leftNode.stab(time));
        } else if (time > this.center && this.rightNode != null) {
            result.addAll(this.rightNode.stab(time));
        }
        return result;
    }

    public List<Interval<Type>> query(Interval<?> target) {
        ArrayList<Interval<Type>> result = new ArrayList<Interval<Type>>();
        for (Map.Entry<Interval<Type>, List<Interval<Type>>> entry : this.intervals.entrySet()) {
            if (entry.getKey().intersects(target)) {
                for (Interval<Type> interval : entry.getValue()) {
                    result.add(interval);
                }
                continue;
            }
            if (entry.getKey().getStart() > target.getEnd()) break;
        }
        if (target.getStart() < this.center && this.leftNode != null) {
            result.addAll(this.leftNode.query(target));
        }
        if (target.getEnd() > this.center && this.rightNode != null) {
            result.addAll(this.rightNode.query(target));
        }
        return result;
    }

    public List<Interval<Type>> queryContains(Interval<?> target) {
        ArrayList<Interval<Type>> result = new ArrayList<Interval<Type>>();
        for (Map.Entry<Interval<Type>, List<Interval<Type>>> entry : this.intervals.entrySet()) {
            if (entry.getKey().contains(target)) {
                for (Interval<Type> interval : entry.getValue()) {
                    result.add(interval);
                }
                continue;
            }
            if (entry.getKey().getStart() > target.getEnd()) break;
        }
        if (target.getStart() < this.center && this.leftNode != null) {
            result.addAll(this.leftNode.queryContains(target));
        }
        if (target.getEnd() > this.center && this.rightNode != null) {
            result.addAll(this.rightNode.queryContains(target));
        }
        return result;
    }

    public double getCenter() {
        return this.center;
    }

    public void setCenter(double center) {
        this.center = center;
    }

    public IntervalNode<Type> getLeft() {
        return this.leftNode;
    }

    public void setLeft(IntervalNode<Type> left) {
        this.leftNode = left;
    }

    public IntervalNode<Type> getRight() {
        return this.rightNode;
    }

    public void setRight(IntervalNode<Type> right) {
        this.rightNode = right;
    }

    private Double getMedian(SortedSet<Double> set) {
        int i = 0;
        int middle = set.size() / 2;
        for (Double point : set) {
            if (i == middle) {
                return point;
            }
            ++i;
        }
        return null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf(this.center) + ": ");
        for (Map.Entry<Interval<Type>, List<Interval<Type>>> entry : this.intervals.entrySet()) {
            sb.append("[" + entry.getKey().getStart() + "," + entry.getKey().getEnd() + "]:{");
            for (Interval<Type> interval : entry.getValue()) {
                sb.append("(" + interval.getStart() + "," + interval.getEnd() + "," + interval.getData() + ")");
            }
            sb.append("} ");
        }
        return sb.toString();
    }
}

