/*
 * Decompiled with CFR 0.152.
 */
package intervalTree;

import intervalTree.Interval;
import intervalTree.IntervalNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class IntervalTree<Type> {
    private IntervalNode<Type> head;
    private List<Interval<Type>> intervalList;
    private boolean inSync;
    private int size;

    public IntervalTree() {
        this.head = new IntervalNode();
        this.intervalList = new ArrayList<Interval<Type>>();
        this.inSync = true;
        this.size = 0;
    }

    public IntervalTree(List<Interval<Type>> intervalList) {
        this.head = new IntervalNode<Type>(intervalList);
        this.intervalList = new ArrayList<Interval<Type>>();
        this.intervalList.addAll(intervalList);
        this.inSync = true;
        this.size = intervalList.size();
    }

    public List<Type> get(double time) {
        List<Interval<Type>> intervals = this.getIntervals(time);
        ArrayList<Type> result = new ArrayList<Type>();
        for (Interval<Type> interval : intervals) {
            result.add(interval.getData());
        }
        return result;
    }

    public List<Interval<Type>> getIntervals(double time) {
        this.build();
        return this.head.stab(time);
    }

    public List<Type> get(double start, double end) {
        List<Interval<Type>> intervals = this.getIntervals(start, end);
        ArrayList<Type> result = new ArrayList<Type>();
        for (Interval<Type> interval : intervals) {
            result.add(interval.getData());
        }
        return result;
    }

    public List<Type> getContainers(double start, double end) {
        List<Interval<Type>> intervals = this.getContainerIntervals(start, end);
        ArrayList<Type> result = new ArrayList<Type>();
        for (Interval<Type> interval : intervals) {
            result.add(interval.getData());
        }
        return result;
    }

    public List<Interval<Type>> getIntervals(double start, double end) {
        this.build();
        return this.head.query(new Interval<Object>(start, end, null));
    }

    public List<Interval<Type>> getContainerIntervals(double start, double end) {
        this.build();
        return this.head.queryContains(new Interval<Object>(start, end, null));
    }

    public void addInterval(Interval<Type> interval) {
        this.intervalList.add(interval);
        this.inSync = false;
    }

    public void addInterval(double begin, double end, Type data) {
        this.intervalList.add(new Interval<Type>(begin, end, data));
        this.inSync = false;
    }

    public boolean inSync() {
        return this.inSync;
    }

    public void build() {
        if (!this.inSync) {
            this.head = new IntervalNode<Type>(this.intervalList);
            this.inSync = true;
            this.size = this.intervalList.size();
        }
    }

    public int currentSize() {
        return this.size;
    }

    public int listSize() {
        return this.intervalList.size();
    }

    public String toString() {
        return this.nodeString(this.head, 0);
    }

    private String nodeString(IntervalNode<Type> node, int level) {
        if (node == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < level) {
            sb.append("\t");
            ++i;
        }
        sb.append(node + "\n");
        sb.append(this.nodeString(node.getLeft(), level + 1));
        sb.append(this.nodeString(node.getRight(), level + 1));
        return sb.toString();
    }

    public Iterator<Interval<Type>> getIntervalIterator() {
        return this.intervalList.iterator();
    }
}

