/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.sun.xacml.attr.AttributeValue;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import test.PEP;
import test.Parameter;

public class AccessRequest {
    private String user;
    private String role;
    private List<Parameter> roleParams;
    private String resource;
    private String operation;
    private Date requestTime;
    private Map<String, AttributeValue> resourceProperties;

    public AccessRequest(String usr, String role, List<Parameter> roleParams, String op, String res, Map<String, AttributeValue> resProperties, Date requestTime) {
        this.user = usr;
        this.role = role;
        this.roleParams = roleParams;
        this.resource = res;
        this.operation = op;
        this.requestTime = requestTime == null ? new Date() : requestTime;
        this.resourceProperties = resProperties;
    }

    public String getUser() {
        return this.user;
    }

    public String getRoleName() {
        return this.role;
    }

    public List<Parameter> getRoleParameters() {
        return this.roleParams;
    }

    public Date getRequestTime() {
        return this.requestTime;
    }

    public String getResource() {
        return this.resource;
    }

    public String getOperation() {
        return this.operation;
    }

    public Set<String> getPropertyNames() {
        return this.resourceProperties.keySet();
    }

    public AttributeValue getPropertyValue(String propertyName) {
        return this.resourceProperties.get(propertyName);
    }

    public String toString() {
        String str = String.valueOf(PEP.getDateFormat().format(this.requestTime)) + " : (" + this.user + "{Playing role:" + this.role + "}, " + this.operation + ", " + this.resource + ")";
        if (this.resourceProperties.size() > 0) {
            str = String.valueOf(str) + "  Supplementary resource info:[";
            Set<String> keys = this.resourceProperties.keySet();
            for (String key : keys) {
                str = String.valueOf(str) + " " + key + "=" + this.resourceProperties.get(key);
            }
            str = String.valueOf(str) + " ]";
        }
        return str;
    }
}

