/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.sun.xacml.attr.AnyURIAttribute;
import com.sun.xacml.attr.AttributeValue;
import com.sun.xacml.attr.DateTimeAttribute;
import com.sun.xacml.attr.GeometryPointAttribute;
import com.sun.xacml.attr.RoleAttribute;
import com.sun.xacml.attr.StringAttribute;
import com.sun.xacml.ctx.Attribute;
import com.sun.xacml.ctx.RequestCtx;
import com.sun.xacml.ctx.Subject;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import java.net.URI;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.apache.log4j.Logger;
import test.AccessRequest;
import test.Parameter;
import test.Resource;
import test.UserDevice;

public class PEP {
    public static DateFormat df = null;
    private Logger log;
    private Map<String, UserDevice> devices;
    private Map<String, Resource> resources;
    private final URI XACML_SUBJECT_ID = this.toURI("urn:oasis:names:tc:xacml:1.0:subject:subject-id");
    private final URI XACML_RESOURCE_ID = this.toURI("urn:oasis:names:tc:xacml:1.0:resource:resource-id");
    private final URI XACML_ACTION_ID = this.toURI("urn:oasis:names:tc:xacml:1.0:action:action-id");
    private final URI XACML_SUBJ_ROLE_ID = this.toURI("urn:oasis:names:tc:xacml:2.0:subject:role");
    private final URI XACML_SUBJ_REQ_TIME_ID = this.toURI("urn:oasis:names:tc:xacml:1.0:subject:request-time");
    private final URI MY_SUBJ_POS_ID = this.toURI("urn:my:subject:position-coord");
    private final URI MY_RES_POS_ID = this.toURI("urn:my:resource:position-coord");
    private final String MY_RES_PROPERTY_PREFIX = "urn:my:resource:property:";
    private final String MY_ROLE_VALUE_PREFIX = "urn:example:role-values:";
    private final String MY_CATEGORY_VALUE_PREFIX = "urn:example:resource-categories:";
    private final URI MY_CATEGORY_ID = this.toURI("urn:example:resource:category-id");

    public PEP() {
        this.devices = new HashMap<String, UserDevice>();
        this.resources = new HashMap<String, Resource>();
        this.log = Logger.getLogger(PEP.class);
    }

    public boolean registerDevice(UserDevice device) {
        return this.devices.put(device.getUsername(), device) != null;
    }

    public boolean registerResource(Resource resource) {
        return this.resources.put(resource.getName(), resource) != null;
    }

    public UserDevice getDeviceOf(String userName) {
        return this.devices.get(userName);
    }

    public static DateFormat getDateFormat() {
        if (df == null) {
            df = new SimpleDateFormat("dd/MM/yyyy HH:mm");
            df.setTimeZone(TimeZone.getDefault());
        }
        return df;
    }

    public RequestCtx[] buildRequestFor(AccessRequest accessReq) {
        HashSet<Subject> subjects = new HashSet<Subject>();
        HashSet<Attribute> subject = new HashSet<Attribute>();
        StringAttribute subjID = StringAttribute.getInstance(accessReq.getUser());
        subject.add(new Attribute(this.XACML_SUBJECT_ID, null, null, subjID));
        URI roleName = this.toURI(String.valueOf("urn:example:role-values:") + accessReq.getRoleName());
        List<Parameter> params = accessReq.getRoleParameters();
        HashMap<String, AttributeValue> paramsMap = new HashMap<String, AttributeValue>();
        HashMap<String, URI> paramsType = new HashMap<String, URI>();
        for (Parameter param : params) {
            String paramName = param.getName();
            AttributeValue paramVal = param.getValue();
            paramsMap.put(paramName, paramVal);
            if (!(param.getValue() instanceof StringAttribute)) continue;
            paramsType.put(paramName, this.toURI("http://www.w3.org/2001/XMLSchema#string"));
        }
        RoleAttribute roleAttr = RoleAttribute.getInstance(roleName, paramsMap, paramsType, paramsMap.size());
        subject.add(new Attribute(this.XACML_SUBJ_ROLE_ID, null, null, roleAttr));
        Coordinate userCoord = this.devices.get(accessReq.getUser()).getPosition();
        GeometryPointAttribute pointAttr = GeometryPointAttribute.getInstance(new GeometryFactory(), userCoord.x, userCoord.y);
        subject.add(new Attribute(this.MY_SUBJ_POS_ID, null, null, pointAttr));
        DateTimeAttribute reqTime = new DateTimeAttribute(accessReq.getRequestTime());
        subject.add(new Attribute(this.XACML_SUBJ_REQ_TIME_ID, null, null, reqTime));
        subjects.add(new Subject(null, subject));
        HashSet<Attribute> resource = new HashSet<Attribute>();
        StringAttribute resourceID = StringAttribute.getInstance(accessReq.getResource());
        resource.add(new Attribute(this.XACML_RESOURCE_ID, null, null, resourceID));
        Resource res = this.resources.get(accessReq.getResource());
        if (res == null) {
            try {
                throw new Exception("Unknown resource: " + accessReq.getResource());
            }
            catch (Exception e) {
                this.log.error((Object)("Unknown resource found in access request: " + accessReq.toString()));
            }
        }
        Coordinate resourceCoord = res.getPosition();
        GeometryPointAttribute resPointAttr = GeometryPointAttribute.getInstance(new GeometryFactory(), resourceCoord.x, resourceCoord.y);
        resource.add(new Attribute(this.MY_RES_POS_ID, null, null, resPointAttr));
        List<String> resCategories = res.getCategories();
        AnyURIAttribute[] categoryAttr = new AnyURIAttribute[resCategories.size()];
        int i = 0;
        while (i < resCategories.size()) {
            categoryAttr[i] = new AnyURIAttribute(this.toURI(String.valueOf("urn:example:resource-categories:") + resCategories.get(i)));
            ++i;
        }
        Set<String> properties = accessReq.getPropertyNames();
        for (String property : properties) {
            AttributeValue propValue = accessReq.getPropertyValue(property);
            URI propertyID = this.toURI(String.valueOf("urn:my:resource:property:") + property);
            resource.add(new Attribute(propertyID, null, null, propValue));
        }
        HashSet<Attribute> action = new HashSet<Attribute>();
        StringAttribute actionID = StringAttribute.getInstance(accessReq.getOperation());
        action.add(new Attribute(this.XACML_ACTION_ID, null, null, actionID));
        HashSet environment = new HashSet();
        RequestCtx[] requests = new RequestCtx[categoryAttr.length];
        int i2 = 0;
        while (i2 < categoryAttr.length) {
            HashSet<Attribute> newResource = new HashSet<Attribute>(resource);
            newResource.add(new Attribute(this.MY_CATEGORY_ID, null, null, categoryAttr[i2]));
            requests[i2] = new RequestCtx(subjects, newResource, action, environment);
            ++i2;
        }
        return requests;
    }

    private URI toURI(String str) {
        return URI.create(str);
    }
}

