/*
 * Decompiled with CFR 0.152.
 */
package test;

public final class StopWatch {
    private long fStart;
    private long fStop;
    private boolean fIsRunning;
    private boolean fHasBeenUsedOnce;

    public static void main(String ... arguments) {
        StopWatch stopwatch = new StopWatch();
        stopwatch.start();
        StringBuilder messageOne = new StringBuilder();
        int numIterations = 5000;
        int idx = 0;
        while (idx < numIterations) {
            messageOne.append("blah");
            ++idx;
        }
        stopwatch.stop();
        System.out.println("The reading for StringBuilder is: " + stopwatch);
        stopwatch.start();
        String messageTwo = null;
        int idx2 = 0;
        while (idx2 < numIterations) {
            messageTwo = String.valueOf(messageTwo) + "blah";
            ++idx2;
        }
        stopwatch.stop();
        if (stopwatch.toValue() > 5L) {
            System.out.println("The reading is high: " + stopwatch);
        } else {
            System.out.println("The reading is low: " + stopwatch);
        }
    }

    public void start() {
        if (this.fIsRunning) {
            throw new IllegalStateException("Must stop before calling start again.");
        }
        this.fStart = System.currentTimeMillis();
        this.fStop = 0L;
        this.fIsRunning = true;
        this.fHasBeenUsedOnce = true;
    }

    public void stop() {
        if (!this.fIsRunning) {
            throw new IllegalStateException("Cannot stop if not currently running.");
        }
        this.fStop = System.currentTimeMillis();
        this.fIsRunning = false;
    }

    public String toString() {
        this.validateIsReadable();
        StringBuilder result = new StringBuilder();
        result.append(this.fStop - this.fStart);
        result.append(" ms");
        return result.toString();
    }

    public long toValue() {
        this.validateIsReadable();
        return this.fStop - this.fStart;
    }

    private void validateIsReadable() {
        if (this.fIsRunning) {
            String message = "Cannot read a stopwatch which is still running.";
            throw new IllegalStateException(message);
        }
        if (!this.fHasBeenUsedOnce) {
            String message = "Cannot read a stopwatch which has never been started.";
            throw new IllegalStateException(message);
        }
    }
}

