/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.sun.xacml.attr.AttributeValue;
import com.sun.xacml.attr.GeometryPointAttribute;
import com.sun.xacml.attr.StringAttribute;
import com.sun.xacml.ctx.RequestCtx;
import com.sun.xacml.ctx.ResponseCtx;
import com.sun.xacml.ctx.Result;
import com.sun.xacml.event.Event;
import com.sun.xacml.event.EventGenericProxy;
import com.sun.xacml.event.EventHandler;
import com.sun.xacml.location.LocationHandler;
import com.sun.xacml.location.LocationNode;
import com.sun.xacml.support.AccessPDP;
import com.sun.xacml.support.EnablingPDP;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.util.Stopwatch;
import com.vividsolutions.jtstest.testrunner.Test;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.log4j.xml.DOMConfigurator;
import test.AccessRequest;
import test.PEP;
import test.Parameter;
import test.Resource;
import test.UserDevice;

public class Testing {
    public static Logger log;

    public static void processLocations(String file) throws Exception {
        String line;
        FileReader fileReader = new FileReader(file);
        log.debug((Object)("Processing locations file: " + file));
        LocationHandler lh = LocationHandler.getInstance(0);
        BufferedReader buffReader = new BufferedReader(fileReader);
        while ((line = buffReader.readLine()) != null) {
            log.debug((Object)("Processing line: " + line));
            String[] elements = line.split("::");
            String command = elements[0];
            if (command.equalsIgnoreCase("createType")) {
                if (lh.addLocationType(elements[1])) {
                    log.info((Object)("Created LocationType: " + elements[1]));
                    continue;
                }
                log.error((Object)("Could not create LocationType: " + elements[1]));
                System.exit(-1);
                continue;
            }
            if (command.equalsIgnoreCase("createTypeRelation")) {
                if (elements[1].contains(">")) {
                    String[] subTypes;
                    String[] types = elements[1].split(">");
                    if (lh.addTypeRelation(types[0], subTypes = types[1].split(","))) {
                        Iterator<LocationNode> it = lh.findLocationType(types[0]).getAdjacents().iterator();
                        String adjs = "";
                        while (it.hasNext()) {
                            adjs = String.valueOf(adjs) + " " + it.next().getName();
                        }
                        log.info((Object)("Created LocationType relation: " + types[0] + ">" + adjs));
                        continue;
                    }
                    log.error((Object)("Could not create relation: " + line));
                    System.exit(-1);
                    continue;
                }
                log.error((Object)("Missing '>' operator: " + line));
                System.exit(-1);
                continue;
            }
            if (!command.equalsIgnoreCase("createLocation")) continue;
            String[] coords = elements[3].split(";");
            Coordinate[] ringCoords = new Coordinate[coords.length];
            int i = 0;
            while (i < coords.length) {
                String[] xys = coords[i].split(",");
                ringCoords[i] = new Coordinate(Double.parseDouble(xys[0]), Double.parseDouble(xys[1]));
                ++i;
            }
            if (lh.createLogicalPolygon(elements[1], elements[2], ringCoords, null)) {
                log.info((Object)("Created LogicalLocation " + elements[1] + "(type:" + elements[2] + ") - " + elements[3]));
                continue;
            }
            log.error((Object)("Could not create location: " + line));
            System.exit(-1);
        }
    }

    public static void main(String[] args) throws Exception {
        String line;
        if (args.length == 0 || args.length > 1) {
            System.out.println("usage: pdp_test folder_path");
            System.exit(-1);
        }
        DOMConfigurator.configure((String)"log4j.properties");
        log = Logger.getLogger(Test.class);
        EventHandler.getInstance().getEventFactory().addEventType("generic", new EventGenericProxy());
        PEP pep = new PEP();
        Stopwatch stopwatch = new Stopwatch();
        log.info((Object)("Start Time:" + stopwatch.getTimeString()));
        String locationsFile = String.valueOf(args[0]) + "/locations";
        try {
            Testing.processLocations(locationsFile);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
            System.exit(-1);
        }
        log.info((Object)("Location Loading Time:" + stopwatch.getTimeString()));
        String[] enablingPolicies = new String[]{String.valueOf(args[0]) + "/enablingPolicy"};
        EnablingPDP enablingPDP = null;
        try {
            enablingPDP = new EnablingPDP(enablingPolicies);
        }
        catch (Exception e) {
            log.fatal((Object)e.getMessage());
            System.exit(-1);
        }
        log.info((Object)("Enabling Policy Time:" + stopwatch.getTimeString()));
        String[] policies = new String[]{String.valueOf(args[0]) + "/policy"};
        AccessPDP accessPDP = null;
        try {
            accessPDP = new AccessPDP("accessPDP", policies, null, enablingPDP);
        }
        catch (Exception e) {
            log.fatal((Object)e.getMessage());
            System.exit(-1);
        }
        log.info((Object)("Load Time:" + stopwatch.getTimeString()));
        String fileName = String.valueOf(args[0]) + "/commands";
        FileReader fr = null;
        try {
            fr = new FileReader(fileName);
        }
        catch (FileNotFoundException e) {
            log.error((Object)e.getMessage());
            System.out.println(e.getMessage());
            System.exit(-1);
        }
        log.debug((Object)("Processing instructions file: " + fileName));
        BufferedReader br = new BufferedReader(fr);
        while ((line = br.readLine()) != null) {
            List evParamList;
            String userT;
            String userS;
            String[] coords;
            UserDevice dev;
            Coordinate coord;
            String[] elements = line.split("::");
            String command = elements[0];
            log.debug((Object)("Processing line: " + line));
            if (command.equalsIgnoreCase("createDevice")) {
                String[] coords2 = elements[2].split(",");
                coord = new Coordinate(Double.parseDouble(coords2[0]), Double.parseDouble(coords2[1]));
                String[] roles = elements[3].split(";");
                HashMap<String, List<Parameter>> rolesMap = new HashMap<String, List<Parameter>>();
                int i = 0;
                while (i < roles.length) {
                    int bracketIndex = roles[i].indexOf("(");
                    String roleName = roles[i].substring(0, bracketIndex);
                    String params = roles[i].substring(bracketIndex + 1, roles[i].length() - 1);
                    LinkedList<Parameter> paramList = new LinkedList<Parameter>();
                    if (params.equals("")) {
                        rolesMap.put(roleName, paramList);
                    } else {
                        String[] param = params.split(",");
                        int j = 0;
                        while (j < param.length) {
                            String[] paramInfo = param[j].split(":");
                            String paramName = paramInfo[0];
                            StringAttribute value = null;
                            if (paramInfo[1].equalsIgnoreCase("string")) {
                                value = StringAttribute.getInstance(paramInfo[2]);
                            }
                            paramList.add(new Parameter(paramName, value));
                            ++j;
                        }
                        rolesMap.put(roleName, paramList);
                    }
                    ++i;
                }
                UserDevice dev2 = new UserDevice(elements[1], rolesMap, coord);
                log.info((Object)("Created " + dev2.toString()));
                pep.registerDevice(dev2);
                continue;
            }
            if (command.equalsIgnoreCase("createResource")) {
                String[] coords3 = elements[2].split(",");
                coord = new Coordinate(Double.parseDouble(coords3[0]), Double.parseDouble(coords3[1]));
                LinkedList<String> catList = new LinkedList<String>();
                String[] categories = elements[3].split(";");
                int i = 0;
                while (i < categories.length) {
                    catList.add(categories[i]);
                    ++i;
                }
                Resource res = new Resource(elements[1], coord, catList);
                log.info((Object)("Created " + res.toString()));
                pep.registerResource(res);
                continue;
            }
            if (command.equalsIgnoreCase("moveUser")) {
                String[] coords4 = elements[2].split(",");
                coord = new Coordinate(Double.parseDouble(coords4[0]), Double.parseDouble(coords4[1]));
                dev = pep.getDeviceOf(elements[1]);
                String info = "User " + dev.getUsername() + " moved from: " + dev.getPosition().toString() + " to: ";
                dev.setPosition(coord);
                info = String.valueOf(info) + dev.getPosition().toString();
                log.info((Object)info);
                continue;
            }
            if (command.equalsIgnoreCase("requestAccess")) {
                List<Parameter> roleParams;
                HashMap<String, AttributeValue> propMap = new HashMap<String, AttributeValue>();
                Date requestD = null;
                if (!elements[5].equalsIgnoreCase("null")) {
                    requestD = PEP.getDateFormat().parse(elements[5]);
                }
                if (elements.length == 7) {
                    String[] props = elements[6].split(";");
                    int i = 0;
                    while (i < props.length) {
                        AttributeValue attr;
                        String[] prop = props[i].split("=");
                        String[] propInfo = prop[0].split(":");
                        if (propInfo[1].equalsIgnoreCase("string")) {
                            attr = StringAttribute.getInstance(prop[1]);
                        } else if (propInfo[1].equalsIgnoreCase("point")) {
                            String[] xy = prop[1].split(",");
                            attr = GeometryPointAttribute.getInstance(new GeometryFactory(), Double.parseDouble(xy[0]), Double.parseDouble(xy[1]));
                        } else {
                            throw new Exception("Unknown type: " + propInfo[1]);
                        }
                        propMap.put(propInfo[0], attr);
                        ++i;
                    }
                }
                if ((roleParams = (dev = pep.getDeviceOf(elements[1])).getParametersForRole(elements[2])) == null) {
                    log.error((Object)("user " + dev.getUsername() + " can't play role: " + elements[2]));
                    System.exit(-1);
                }
                AccessRequest accessReq = new AccessRequest(elements[1], elements[2], roleParams, elements[3], elements[4], propMap, requestD);
                log.info((Object)("Processing access request: " + accessReq.toString()));
                RequestCtx[] requests = pep.buildRequestFor(accessReq);
                int result = -1;
                int index = 0;
                while (result != 0 && index < requests.length) {
                    log.info((Object)("Processing request #" + (index + 1) + " of " + requests.length));
                    ByteArrayOutputStream stream = new ByteArrayOutputStream();
                    requests[index].encode(stream);
                    log.debug((Object)stream);
                    ResponseCtx response = null;
                    try {
                        response = accessPDP.evaluate(requests[index++]);
                    }
                    catch (Exception e) {
                        log.fatal((Object)e.getMessage());
                        System.exit(-1);
                    }
                    Set results = response.getResults();
                    result = ((Result)results.iterator().next()).getDecision();
                    log.info((Object)("Result: " + Result.DECISIONS[result]));
                }
                log.info((Object)("After Evaluation Time:" + stopwatch.getTimeString()));
                if (result == 0) {
                    log.info((Object)("--> Access granted. {for request: " + accessReq.toString() + "}"));
                    System.out.println("--> Access granted. {for request: " + accessReq.toString() + "}");
                    continue;
                }
                log.info((Object)("--> Access denied. {for request: " + accessReq.toString() + "}"));
                System.out.println("--> Access denied. {for request: " + accessReq.toString() + "}");
                continue;
            }
            if (command.equalsIgnoreCase("createEvent")) {
                int evPrios = 0;
                coord = null;
                if (!elements[5].equalsIgnoreCase("null")) {
                    coords = elements[5].split(",");
                    coord = new Coordinate(Double.parseDouble(coords[0]), Double.parseDouble(coords[1]));
                }
                try {
                    evPrios = Integer.parseInt(elements[1]);
                }
                catch (Exception e) {
                    log.warn((Object)("event priority set to default." + e.getMessage()));
                }
                userS = null;
                if (!elements[3].equalsIgnoreCase("null")) {
                    userS = elements[3];
                }
                userT = null;
                if (!elements[4].equalsIgnoreCase("null")) {
                    userT = elements[4];
                }
                evParamList = EventGenericProxy.constructParameterList(evPrios, elements[2], userS, userT, coord);
                Event ev = EventHandler.getInstance().createEvent("generic", evParamList);
                log.info((Object)("Generated " + ev.toString()));
                continue;
            }
            if (!command.equalsIgnoreCase("removeEvent")) continue;
            int evPrios = 0;
            coord = null;
            if (!elements[5].equalsIgnoreCase("null")) {
                coords = elements[5].split(",");
                coord = new Coordinate(Double.parseDouble(coords[0]), Double.parseDouble(coords[1]));
            }
            try {
                evPrios = Integer.parseInt(elements[1]);
            }
            catch (Exception e) {
                log.warn((Object)("event priority set to default." + e.getMessage()));
            }
            userS = null;
            if (!elements[3].equalsIgnoreCase("null")) {
                userS = elements[3];
            }
            userT = null;
            if (!elements[4].equalsIgnoreCase("null")) {
                userT = elements[4];
            }
            evParamList = EventGenericProxy.constructParameterList(evPrios, elements[2], userS, userT, coord);
            EventHandler.getInstance().removeEvent("generic", evParamList);
            EventHandler.getInstance().getAllEventsNamed(elements[2]);
            log.info((Object)("Removed event: " + elements[2]));
        }
        log.debug((Object)("Total elapsed time: " + stopwatch.stop()));
        log.info((Object)("Total elapsed time: " + stopwatch.getTimeString()));
    }
}

