/*
 * Decompiled with CFR 0.152.
 */
package test;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;

public class TestingRules {
    public void createAccessPolicy(int numRoles) throws IOException {
        FileWriter fw = new FileWriter("/home/davide/test/tempo_rules/policy");
        BufferedWriter out = new BufferedWriter(fw);
        out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        out.write("<PolicySet xmlns=\"urn:oasis:names:tc:xacml:2.0:policy:schema:os\" PolicySetId=\"RPS:all:roles\" PolicyCombiningAlgId=\"urn:oasis:names:tc:xacml:1.0:policy-combining-algorithm:permit-overrides\">\n");
        out.write("<Target />\n");
        int i = 1;
        while (i <= numRoles) {
            out.write("<Policy xmlns=\"urn:oasis:names:tc:xacml:2.0:policy:schema:os\" PolicyId=\"Es1:rolePS:role" + i + "\"" + " RuleCombiningAlgId=\"urn:oasis:names:tc:xacml:1.0:rule-combining-algorithm:permit-overrides\">\n");
            out.write("<Target>\n");
            out.write("<Subjects>\n");
            out.write("<Subject>\n");
            out.write("<SubjectMatch MatchId=\"urn:my:function:role:is-instance\">\n");
            out.write("<AttributeValue DataType=\"urn:my:dataType:role\">\n");
            out.write("<RoleName>urn:example:role-values:role" + i + "</RoleName>\n");
            out.write("<RoleParams>\n");
            out.write("<Param Name=\"reparto\" DataType=\"http://www.w3.org/2001/XMLSchema#string\" />\n");
            out.write("</RoleParams>\n");
            out.write("</AttributeValue>\n");
            out.write("<SubjectAttributeDesignator AttributeId=\"urn:oasis:names:tc:xacml:2.0:subject:role\" DataType=\"urn:my:dataType:role\" />\n");
            out.write("</SubjectMatch>\n");
            out.write("</Subject>\n");
            out.write("</Subjects>\n");
            out.write("</Target>\n");
            out.write("<Rule RuleId=\"Read:cartelle:reparto\" Effect=\"Permit\">\n");
            out.write("<Target>\n");
            out.write("<Resources>\n");
            out.write("<Resource>\n");
            out.write("<ResourceMatch MatchId=\"urn:oasis:names:tc:xacml:1.0:function:anyURI-equal\">\n");
            out.write("<AttributeValue DataType=\"http://www.w3.org/2001/XMLSchema#anyURI\">urn:example:resource-categories:cartelleCliniche</AttributeValue>\n");
            out.write("<ResourceAttributeDesignator AttributeId=\"urn:example:resource:category-id\" DataType=\"http://www.w3.org/2001/XMLSchema#anyURI\"/>\n");
            out.write("</ResourceMatch>\n");
            out.write("</Resource>\n");
            out.write("</Resources>\n");
            out.write("<Actions>\n");
            out.write("<Action>\n");
            out.write("<ActionMatch MatchId=\"urn:oasis:names:tc:xacml:1.0:function:string-equal\">\n");
            out.write("<AttributeValue DataType=\"http://www.w3.org/2001/XMLSchema#string\">read</AttributeValue>\n");
            out.write("<ActionAttributeDesignator AttributeId=\"urn:oasis:names:tc:xacml:1.0:action:action-id\" DataType=\"http://www.w3.org/2001/XMLSchema#string\"/>\n");
            out.write("</ActionMatch>\n");
            out.write("</Action>\n");
            out.write("</Actions>\n");
            out.write("</Target>\n");
            out.write("<Condition>\n");
            out.write("<Apply FunctionId=\"urn:oasis:names:tc:xacml:1.0:function:string-equal\">\n");
            out.write("<Apply FunctionId=\"urn:oasis:names:tc:xacml:1.0:function:string-one-and-only\">\n");
            out.write("<ResourceAttributeDesignator AttributeId=\"urn:my:resource:property:reparto\" DataType=\"http://www.w3.org/2001/XMLSchema#string\" />\n");
            out.write("</Apply>\n");
            out.write("<Apply FunctionId=\"urn:oasis:names:tc:xacml:1.0:function:string-one-and-only\">\n");
            out.write("<SubjectAttributeDesignator AttributeId=\"urn:my:parameter:reparto\" DataType=\"http://www.w3.org/2001/XMLSchema#string\" />\n");
            out.write("</Apply>\n");
            out.write("</Apply>\n");
            out.write("</Condition>\n");
            out.write("</Rule>\n");
            out.write("</Policy>\n");
            ++i;
        }
        out.write("</PolicySet>");
        out.close();
    }

    public void createEnablingPolicy1_1(int numRules) throws IOException {
        FileWriter fw = new FileWriter("/home/davide/test/tempo_rules/enablingPolicy");
        BufferedWriter out = new BufferedWriter(fw);
        out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        out.write("<Policy xmlns=\"urn:oasis:names:tc:xacml:2.0:policy:schema:os\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"urn:oasis:names:tc:xacml:2.0:policy:schema:os http://docs.oasis-open.org/xacml/access_control-xacml-2.0-policy-schema-os.xsd\" PolicyId=\"urn:oasis:names:tc:example:EnablePolicy\" RuleCombiningAlgId=\"my:rule-combining-algorithm:deny-overrides\">\n");
        out.write("<Target>\n");
        out.write("<Subjects>\n");
        out.write("<Subject>\n");
        out.write("<SubjectMatch MatchId=\"urn:oasis:names:tc:xacml:1.0:function:string-equal\">\n");
        out.write("<AttributeValue DataType=\"http://www.w3.org/2001/XMLSchema#string\">accessPDP</AttributeValue>\n");
        out.write("<SubjectAttributeDesignator SubjectCategory=\"urn:oasis:names:tc:xacml:1.0:subject-category:recipient-subject\" AttributeId=\"urn:oasis:names:tc:xacml:1.0:subject-category:subject-id\" DataType=\"http://www.w3.org/2001/XMLSchema#string\" />\n");
        out.write("</SubjectMatch>\n");
        out.write("</Subject>\n");
        out.write("</Subjects>\n");
        out.write("<Actions>\n");
        out.write("<Action>\n");
        out.write("<ActionMatch MatchId=\"urn:oasis:names:tc:xacml:1.0:function:string-equal\">\n");
        out.write("<AttributeValue DataType=\"http://www.w3.org/2001/XMLSchema#string\">enableRole</AttributeValue>\n");
        out.write("<ActionAttributeDesignator AttributeId=\"urn:oasis:names:tc:xacml:1.0:action:action-id\" DataType=\"http://www.w3.org/2001/XMLSchema#string\" />\n");
        out.write("</ActionMatch>\n");
        out.write("</Action>\n");
        out.write("</Actions>\n");
        out.write("</Target>\n");
        int i = 1;
        while (i <= numRules) {
            out.write("<Rule RuleId=\"urn:oasis:names:tc:xacml:2.0:example:rule" + i + "\" Effect=\"Permit\" Priority=\"0\">\n");
            out.write("<Target>\n");
            out.write("<Resources>\n");
            out.write("<Resource>\n");
            out.write("<ResourceMatch MatchId=\"urn:my:function:role:same-instance\">\n");
            out.write("<AttributeValue DataType=\"urn:my:dataType:role\">\n");
            out.write("<RoleName>urn:example:role-values:role" + i + "</RoleName>\n");
            out.write("<RoleParams>\n");
            out.write("<Param Name=\"reparto\" DataType=\"http://www.w3.org/2001/XMLSchema#string\">cardiologia</Param>\n");
            out.write("</RoleParams>\n");
            out.write("</AttributeValue>\n");
            out.write("<ResourceAttributeDesignator AttributeId=\"urn:oasis:names:tc:xacml:1.0:resource:resource-id\" DataType=\"urn:my:dataType:role\" />\n");
            out.write("</ResourceMatch>\n");
            out.write("</Resource>\n");
            out.write("</Resources>\n");
            out.write("</Target>\n");
            out.write("<Condition>\n");
            out.write("<Apply FunctionId=\"urn:my:function:spatial:point-within-location-logical\">\n");
            out.write("<AttributeValue DataType=\"http://www.w3.org/2001/XMLSchema#string\">cardiologia</AttributeValue>\n");
            out.write("<Apply FunctionId=\"urn:my:function:spatial:geometryAttribute-one-and-only\">\n");
            out.write("<SubjectAttributeDesignator AttributeId=\"urn:my:subject:position-coord\" DataType=\"urn:ogc:def:dataType:geoxacml:1.0:geometry\" />\n");
            out.write("</Apply>\n");
            out.write("</Apply>\n");
            out.write("</Condition>\n");
            out.write("</Rule>\n");
            ++i;
        }
        out.write("</Policy>\n");
        out.close();
    }

    public void createEnablingPolicy1_10(int numRules, String[] locazioni, int mostSpecific) throws IOException {
        FileWriter fw = new FileWriter("/home/davide/test/tempo_rules/enablingPolicy");
        BufferedWriter out = new BufferedWriter(fw);
        out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        out.write("<Policy xmlns=\"urn:oasis:names:tc:xacml:2.0:policy:schema:os\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"urn:oasis:names:tc:xacml:2.0:policy:schema:os http://docs.oasis-open.org/xacml/access_control-xacml-2.0-policy-schema-os.xsd\" PolicyId=\"urn:oasis:names:tc:example:EnablePolicy\" RuleCombiningAlgId=\"my:rule-combining-algorithm:deny-overrides\">\n");
        out.write("<Target>\n");
        out.write("<Subjects>\n");
        out.write("<Subject>\n");
        out.write("<SubjectMatch MatchId=\"urn:oasis:names:tc:xacml:1.0:function:string-equal\">\n");
        out.write("<AttributeValue DataType=\"http://www.w3.org/2001/XMLSchema#string\">accessPDP</AttributeValue>\n");
        out.write("<SubjectAttributeDesignator SubjectCategory=\"urn:oasis:names:tc:xacml:1.0:subject-category:recipient-subject\" AttributeId=\"urn:oasis:names:tc:xacml:1.0:subject-category:subject-id\" DataType=\"http://www.w3.org/2001/XMLSchema#string\" />\n");
        out.write("</SubjectMatch>\n");
        out.write("</Subject>\n");
        out.write("</Subjects>\n");
        out.write("<Actions>\n");
        out.write("<Action>\n");
        out.write("<ActionMatch MatchId=\"urn:oasis:names:tc:xacml:1.0:function:string-equal\">\n");
        out.write("<AttributeValue DataType=\"http://www.w3.org/2001/XMLSchema#string\">enableRole</AttributeValue>\n");
        out.write("<ActionAttributeDesignator AttributeId=\"urn:oasis:names:tc:xacml:1.0:action:action-id\" DataType=\"http://www.w3.org/2001/XMLSchema#string\" />\n");
        out.write("</ActionMatch>\n");
        out.write("</Action>\n");
        out.write("</Actions>\n");
        out.write("</Target>\n");
        int i = 1;
        while (i <= numRules) {
            if (i == numRules / 2) {
                int numLocs = locazioni.length;
                int j = 1;
                while (j <= numLocs) {
                    out.write("<Rule RuleId=\"urn:oasis:names:tc:xacml:2.0:example:rule" + i + "_" + j + "\" Effect=\"Permit\" Priority=\"0\">\n");
                    out.write("<Target>\n");
                    out.write("<Resources>\n");
                    out.write("<Resource>\n");
                    out.write("<ResourceMatch MatchId=\"urn:my:function:role:same-instance\">\n");
                    out.write("<AttributeValue DataType=\"urn:my:dataType:role\">\n");
                    out.write("<RoleName>urn:example:role-values:role" + i + "</RoleName>\n");
                    out.write("<RoleParams>\n");
                    out.write("<Param Name=\"reparto\" DataType=\"http://www.w3.org/2001/XMLSchema#string\">" + locazioni[0] + "</Param>\n");
                    out.write("</RoleParams>\n");
                    out.write("</AttributeValue>\n");
                    out.write("<ResourceAttributeDesignator AttributeId=\"urn:oasis:names:tc:xacml:1.0:resource:resource-id\" DataType=\"urn:my:dataType:role\" />\n");
                    out.write("</ResourceMatch>\n");
                    out.write("</Resource>\n");
                    out.write("</Resources>\n");
                    out.write("</Target>\n");
                    out.write("<Condition>\n");
                    out.write("<Apply FunctionId=\"urn:my:function:spatial:point-within-location-logical\">\n");
                    out.write("<AttributeValue DataType=\"http://www.w3.org/2001/XMLSchema#string\">" + locazioni[j - 1] + "</AttributeValue>\n");
                    out.write("<Apply FunctionId=\"urn:my:function:spatial:geometryAttribute-one-and-only\">\n");
                    out.write("<SubjectAttributeDesignator AttributeId=\"urn:my:subject:position-coord\" DataType=\"urn:ogc:def:dataType:geoxacml:1.0:geometry\" />\n");
                    out.write("</Apply>\n");
                    out.write("</Apply>\n");
                    out.write("</Condition>\n");
                    out.write("</Rule>\n");
                    ++j;
                }
                j = 1;
                while (j <= numLocs) {
                    out.write("<Rule RuleId=\"urn:oasis:names:tc:xacml:2.0:example:rule" + i + "_" + (j + numLocs) + "\" Effect=\"Permit\" Priority=\"1\">\n");
                    out.write("<Target>\n");
                    out.write("<Resources>\n");
                    out.write("<Resource>\n");
                    out.write("<ResourceMatch MatchId=\"urn:my:function:role:same-instance\">\n");
                    out.write("<AttributeValue DataType=\"urn:my:dataType:role\">\n");
                    out.write("<RoleName>urn:example:role-values:role" + i + "</RoleName>\n");
                    out.write("<RoleParams>\n");
                    out.write("<Param Name=\"reparto\" DataType=\"http://www.w3.org/2001/XMLSchema#string\">" + locazioni[0] + "</Param>\n");
                    out.write("</RoleParams>\n");
                    out.write("</AttributeValue>\n");
                    out.write("<ResourceAttributeDesignator AttributeId=\"urn:oasis:names:tc:xacml:1.0:resource:resource-id\" DataType=\"urn:my:dataType:role\" />\n");
                    out.write("</ResourceMatch>\n");
                    out.write("</Resource>\n");
                    out.write("</Resources>\n");
                    out.write("</Target>\n");
                    out.write("<Condition>\n");
                    out.write("<Apply FunctionId=\"urn:my:function:spatial:point-within-location-logical\">\n");
                    out.write("<AttributeValue DataType=\"http://www.w3.org/2001/XMLSchema#string\">" + locazioni[j - 1] + "</AttributeValue>\n");
                    out.write("<Apply FunctionId=\"urn:my:function:spatial:geometryAttribute-one-and-only\">\n");
                    out.write("<SubjectAttributeDesignator AttributeId=\"urn:my:subject:position-coord\" DataType=\"urn:ogc:def:dataType:geoxacml:1.0:geometry\" />\n");
                    out.write("</Apply>\n");
                    out.write("</Apply>\n");
                    out.write("</Condition>\n");
                    out.write("</Rule>\n");
                    ++j;
                }
                j = 1;
                while (j <= numLocs) {
                    if (j == mostSpecific + 1) {
                        out.write("<Rule RuleId=\"urn:oasis:names:tc:xacml:2.0:example:rule" + i + "_" + (j + 2 * numLocs) + "\" Effect=\"Permit\" Priority=\"1\">\n");
                    } else {
                        out.write("<Rule RuleId=\"urn:oasis:names:tc:xacml:2.0:example:rule" + i + "_" + (j + 2 * numLocs) + "\" Effect=\"Deny\" Priority=\"1\">\n");
                    }
                    out.write("<Target>\n");
                    out.write("<Resources>\n");
                    out.write("<Resource>\n");
                    out.write("<ResourceMatch MatchId=\"urn:my:function:role:same-instance\">\n");
                    out.write("<AttributeValue DataType=\"urn:my:dataType:role\">\n");
                    out.write("<RoleName>urn:example:role-values:role" + i + "</RoleName>\n");
                    out.write("<RoleParams>\n");
                    out.write("<Param Name=\"reparto\" DataType=\"http://www.w3.org/2001/XMLSchema#string\">" + locazioni[0] + "</Param>\n");
                    out.write("</RoleParams>\n");
                    out.write("</AttributeValue>\n");
                    out.write("<ResourceAttributeDesignator AttributeId=\"urn:oasis:names:tc:xacml:1.0:resource:resource-id\" DataType=\"urn:my:dataType:role\" />\n");
                    out.write("</ResourceMatch>\n");
                    out.write("</Resource>\n");
                    out.write("</Resources>\n");
                    out.write("</Target>\n");
                    out.write("<Condition>\n");
                    out.write("<Apply FunctionId=\"urn:oasis:names:tc:xacml:1.0:function:and\">\n");
                    out.write("<Apply FunctionId=\"urn:my:function:spatial:point-within-location-logical\">\n");
                    out.write("<AttributeValue DataType=\"http://www.w3.org/2001/XMLSchema#string\">" + locazioni[j - 1] + "</AttributeValue>\n");
                    out.write("<Apply FunctionId=\"urn:my:function:spatial:geometryAttribute-one-and-only\">\n");
                    out.write("<SubjectAttributeDesignator AttributeId=\"urn:my:subject:position-coord\" DataType=\"urn:ogc:def:dataType:geoxacml:1.0:geometry\" />\n");
                    out.write("</Apply>\n");
                    out.write("</Apply>\n");
                    out.write("<Apply FunctionId=\"urn:my:function:event:visible-at\">\n");
                    out.write("<AttributeValue DataType=\"http://www.w3.org/2001/XMLSchema#string\">evento</AttributeValue>\n");
                    out.write("<Apply FunctionId=\"urn:my:function:spatial:geometryAttribute-one-and-only\">\n");
                    out.write("<SubjectAttributeDesignator AttributeId=\"urn:my:subject:position-coord\" DataType=\"urn:ogc:def:dataType:geoxacml:1.0:geometry\" />\n");
                    out.write("</Apply>\n");
                    out.write("<Apply FunctionId=\"urn:oasis:names:tc:xacml:1.0:function:string-one-and-only\">\n");
                    out.write("<SubjectAttributeDesignator AttributeId=\"urn:oasis:names:tc:xacml:1.0:subject-category:subject-id\" DataType=\"http://www.w3.org/2001/XMLSchema#string\" />\n");
                    out.write("</Apply>\n");
                    out.write("</Apply>\n");
                    out.write("</Apply>\n");
                    out.write("</Condition>\n");
                    out.write("</Rule>\n");
                    ++j;
                }
            } else {
                out.write("<Rule RuleId=\"urn:oasis:names:tc:xacml:2.0:example:rule" + i + "\" Effect=\"Permit\" Priority=\"0\">\n");
                out.write("<Target>\n");
                out.write("<Resources>\n");
                out.write("<Resource>\n");
                out.write("<ResourceMatch MatchId=\"urn:my:function:role:same-instance\">\n");
                out.write("<AttributeValue DataType=\"urn:my:dataType:role\">\n");
                out.write("<RoleName>urn:example:role-values:role" + i + "</RoleName>\n");
                out.write("<RoleParams>\n");
                out.write("<Param Name=\"reparto\" DataType=\"http://www.w3.org/2001/XMLSchema#string\">cardiologia</Param>\n");
                out.write("</RoleParams>\n");
                out.write("</AttributeValue>\n");
                out.write("<ResourceAttributeDesignator AttributeId=\"urn:oasis:names:tc:xacml:1.0:resource:resource-id\" DataType=\"urn:my:dataType:role\" />\n");
                out.write("</ResourceMatch>\n");
                out.write("</Resource>\n");
                out.write("</Resources>\n");
                out.write("</Target>\n");
                out.write("<Condition>\n");
                out.write("<Apply FunctionId=\"urn:my:function:spatial:point-within-location-logical\">\n");
                out.write("<AttributeValue DataType=\"http://www.w3.org/2001/XMLSchema#string\">cardiologia</AttributeValue>\n");
                out.write("<Apply FunctionId=\"urn:my:function:spatial:geometryAttribute-one-and-only\">\n");
                out.write("<SubjectAttributeDesignator AttributeId=\"urn:my:subject:position-coord\" DataType=\"urn:ogc:def:dataType:geoxacml:1.0:geometry\" />\n");
                out.write("</Apply>\n");
                out.write("</Apply>\n");
                out.write("</Condition>\n");
                out.write("</Rule>\n");
            }
            ++i;
        }
        out.write("</Policy>\n");
        out.close();
    }

    public void createInstructions(int numRoles) throws IOException {
        FileWriter fw = new FileWriter("/home/davide/test/tempo_rules/istruzioni");
        BufferedWriter out = new BufferedWriter(fw);
        out.write("createDevice::Dr.House::0.5,0.5::role" + numRoles / 2 + "(reparto:string:cardiologia)\n");
        out.write("createResource::cartella1::1,2::cartelleCliniche\n");
        out.write("createEvent::0::evento::null::null::0.4,0.4\n");
        out.write("requestAccess::Dr.House::role" + numRoles / 2 + "::read::cartella1::null::reparto:string=cardiologia\n");
        out.close();
    }

    public void createTestEnvironment1(int numRoles) throws IOException {
        this.createAccessPolicy(numRoles);
        this.createEnablingPolicy1_1(numRoles);
        this.createInstructions(numRoles);
    }

    public void createTestEnvironment2(int numRoles, String[] locazioni, int mostSpecific) throws IOException {
        this.createAccessPolicy(numRoles);
        this.createEnablingPolicy1_10(numRoles, locazioni, mostSpecific);
        this.createInstructions(numRoles);
    }

    public static void main(String[] args) throws Exception {
        TestingRules tr = new TestingRules();
        String[] locazioni = new String[]{"cardiologia", "sala1", "Pellegrini"};
        int mostSpecific = 1;
        tr.createTestEnvironment2(10000, locazioni, mostSpecific);
    }
}

