/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.sun.xacml.event.EventHandler;
import com.sun.xacml.location.LocationHandler;
import com.sun.xacml.location.LocationNode;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jtstest.testrunner.Test;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.apache.log4j.xml.DOMConfigurator;
import test.Testing;

public class TestingSpace {
    public static Logger log;
    public static FileWriter resF;
    public static BufferedWriter resB;

    public static void createSpace(int n, int k) throws IOException {
        FileWriter fw = new FileWriter("locations");
        BufferedWriter out = new BufferedWriter(fw);
        out.write("createType::tipo\n");
        int n1 = n - k;
        int i = 1;
        while (i <= n1) {
            out.write("createLocation::locN_" + i + "::tipo::0,0;-" + i + ",0;-" + i + ",-" + i + ";0,-" + i + ";0,0\n");
            ++i;
        }
        i = 1;
        while (i <= k) {
            out.write("createLocation::locK_" + i + "::tipo::0,0;" + i + ",0;" + i + "," + i + ";0," + i + ";0,0\n");
            ++i;
        }
        out.close();
    }

    public static void processLocations(String file) throws Exception {
        String line;
        FileReader fileReader = new FileReader(file);
        log.debug((Object)("Processing locations file: " + file));
        LocationHandler lh = LocationHandler.getInstance(0);
        BufferedReader buffReader = new BufferedReader(fileReader);
        while ((line = buffReader.readLine()) != null) {
            log.debug((Object)("Processing line: " + line));
            String[] elements = line.split("::");
            String command = elements[0];
            if (command.equalsIgnoreCase("createType")) {
                if (lh.addLocationType(elements[1])) {
                    log.info((Object)("Created LocationType: " + elements[1]));
                    continue;
                }
                log.error((Object)("Could not create LocationType: " + elements[1]));
                System.exit(-1);
                continue;
            }
            if (command.equalsIgnoreCase("createTypeRelation")) {
                if (elements[1].contains(">")) {
                    String[] subTypes;
                    String[] types = elements[1].split(">");
                    if (lh.addTypeRelation(types[0], subTypes = types[1].split(","))) {
                        Iterator<LocationNode> it = lh.findLocationType(types[0]).getAdjacents().iterator();
                        String adjs = "";
                        while (it.hasNext()) {
                            adjs = String.valueOf(adjs) + " " + it.next().getName();
                        }
                        log.info((Object)("Created LocationType relation: " + types[0] + ">" + adjs));
                        continue;
                    }
                    log.error((Object)("Could not create relation: " + line));
                    System.exit(-1);
                    continue;
                }
                log.error((Object)("Missing '>' operator: " + line));
                System.exit(-1);
                continue;
            }
            if (!command.equalsIgnoreCase("createLocation")) continue;
            String[] coords = elements[3].split(";");
            Coordinate[] ringCoords = new Coordinate[coords.length];
            int i = 0;
            while (i < coords.length) {
                String[] xys = coords[i].split(",");
                ringCoords[i] = new Coordinate(Double.parseDouble(xys[0]), Double.parseDouble(xys[1]));
                ++i;
            }
            if (lh.createLogicalPolygon(elements[1], elements[2], ringCoords, null)) {
                log.info((Object)("Created LogicalLocation " + elements[1] + "(type:" + elements[2] + ") - " + elements[3]));
                continue;
            }
            log.error((Object)("Could not create location: " + line));
            System.exit(-1);
        }
    }

    public static void main(String[] args) throws Exception {
        DOMConfigurator.configure((String)"../log4j.properties");
        log = Logger.getLogger(Test.class);
        FileWriter fw = new FileWriter("results_spazio");
        BufferedWriter out = new BufferedWriter(fw);
        out.write("Ld\tTot\n");
        out.close();
        String[] newArgs = new String[]{"../testing", "spazio"};
        int numLocs = 1500;
        int stepK = 50;
        int k = 0;
        while (k <= numLocs) {
            if (k > 0) {
                LocationHandler.getInstance(0).erase();
                EventHandler.getInstance().erase();
            }
            TestingSpace.createSpace(numLocs, k);
            Testing.main(newArgs);
            k += stepK;
        }
    }
}

