/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.sun.xacml.Indenter;
import com.vividsolutions.jts.geom.Coordinate;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import test.Parameter;

public class UserDevice {
    private String userName;
    private Map<String, List<Parameter>> roleInstances;
    private Coordinate userPosition;

    public UserDevice(String uName, Map<String, List<Parameter>> roles, Coordinate uPos) {
        this.userName = uName;
        this.roleInstances = roles;
        this.userPosition = uPos;
    }

    public String getUsername() {
        return this.userName;
    }

    public Coordinate getPosition() {
        return this.userPosition;
    }

    public List<Parameter> getParametersForRole(String roleName) {
        return this.roleInstances.get(roleName);
    }

    public void setPosition(Coordinate newPos) {
        this.userPosition = newPos;
    }

    public String toString() {
        String str = "UserDevice for " + this.userName + ", actual position: " + this.userPosition.toString() + ", assigned role instances: {";
        Set<String> rNames = this.roleInstances.keySet();
        for (String rName : rNames) {
            str = String.valueOf(str) + " " + rName + "(";
            List<Parameter> params = this.roleInstances.get(rName);
            for (Parameter par : params) {
                str = String.valueOf(str) + " " + par.toString();
            }
            str = String.valueOf(str) + ")";
        }
        return String.valueOf(str) + "}";
    }

    public void encode(OutputStream output) {
        this.encode(output, new Indenter());
    }

    public void encode(OutputStream output, Indenter ind) {
        PrintStream out = new PrintStream(output);
        String startLev = ind.makeString();
        ind.in();
        String firstLev = ind.makeString();
        ind.in();
        String secondLev = ind.makeString();
        out.println(String.format("%sUserDevice for %s", startLev, this.userName));
        out.println(String.format("%sactual position:%s", firstLev, this.userPosition.toString()));
        out.println(String.format("%sassigned role instances:", firstLev));
        Set<String> rNames = this.roleInstances.keySet();
        ind.in();
        for (String rName : rNames) {
            out.println(String.format("%s%s(", secondLev, rName));
            List<Parameter> params = this.roleInstances.get(rName);
            for (Parameter par : params) {
                par.encode(output, ind);
            }
            out.println(String.format("%s)", secondLev));
        }
    }
}

