/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.translator;

import com.sun.xacml.translator.RoleTemplate;
import com.sun.xacml.translator.TimeExpression;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class Policy_Translator {
    public String path;
    public static Map<String, RoleTemplate> rolesMap;
    public Map<String, TimeExpression> timeExps;

    public static String buildMapName(RoleTemplate rt) {
        return String.valueOf(rt.getName()) + "_" + rt.getParams().size();
    }

    public static String buildMapName(String roleName, String[] params) {
        if (params.length == 1 && params[0].contentEquals("")) {
            return String.valueOf(roleName) + "_0";
        }
        return String.valueOf(roleName) + "_" + params.length;
    }

    public void insertNewRole(RoleTemplate rt) {
        String key = Policy_Translator.buildMapName(rt);
        if (rolesMap.containsKey(key)) {
            System.out.println("ERROR. A role named '" + rt.getName() + "' with " + rt.getParams().size() + " parameter(s) is already defined.");
            System.exit(-1);
        }
        rolesMap.put(key, rt);
    }

    public static RoleTemplate getDefinedTemplate(String roleName) {
        return rolesMap.get(roleName);
    }

    public Policy_Translator() {
        rolesMap = new HashMap<String, RoleTemplate>();
        this.timeExps = new HashMap<String, TimeExpression>();
    }

    public void processRole(String line, BufferedReader br) throws IOException {
        String roleDef = line;
        if (!line.contains(".")) {
            while ((line = br.readLine()) != null) {
                roleDef = String.valueOf(roleDef) + line;
                if (line.contains(".")) break;
            }
        }
        RoleTemplate newRole = RoleTemplate.parseDefinition(roleDef);
        this.insertNewRole(newRole);
    }

    public void processPolicyFile(String filePath) throws IOException {
        String line;
        int endPath = filePath.lastIndexOf("/");
        this.path = filePath.substring(0, endPath);
        FileReader fr = new FileReader(filePath);
        BufferedReader buffReader = new BufferedReader(fr);
        while ((line = buffReader.readLine()) != null) {
            if (line.contains("role")) {
                this.processRole(line, buffReader);
            }
            if (line.contains("TimeExp")) {
                TimeExpression newTe = TimeExpression.processTimeExp(line);
                this.timeExps.put(newTe.getName(), newTe);
            }
            if (!line.contains("enable") && !line.contains("disable")) continue;
            this.writeEnablingPolicy(line, buffReader);
        }
    }

    public void writeRolePolicy() throws IOException {
        FileWriter fw = new FileWriter(String.valueOf(this.path) + "/policy");
        BufferedWriter out = new BufferedWriter(fw);
        out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        out.write("<PolicySet xmlns=\"urn:oasis:names:tc:xacml:2.0:policy:schema:os\" PolicySetId=\"RPS:all:roles\" PolicyCombiningAlgId=\"urn:oasis:names:tc:xacml:1.0:policy-combining-algorithm:permit-overrides\">\n");
        out.write("<Target />\n");
        Set<String> keys = rolesMap.keySet();
        for (String key : keys) {
            RoleTemplate rt = rolesMap.get(key);
            rt.write(out);
        }
        out.write("</PolicySet>");
        out.close();
    }

    public void writeEnablingPolicy(String line, BufferedReader buffR) throws IOException {
        FileWriter fw = new FileWriter(String.valueOf(this.path) + "/enablingPolicy");
        BufferedWriter out = new BufferedWriter(fw);
        out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        out.write("<Policy xmlns=\"urn:oasis:names:tc:xacml:2.0:policy:schema:os\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"urn:oasis:names:tc:xacml:2.0:policy:schema:os http://docs.oasis-open.org/xacml/access_control-xacml-2.0-policy-schema-os.xsd\" PolicyId=\"urn:oasis:names:tc:example:EnablingPolicy\" RuleCombiningAlgId=\"my:rule-combining-algorithm:deny-overrides\">\n");
        out.write("<Target>\n");
        out.write("<Subjects>\n");
        out.write("<Subject>\n");
        out.write("<SubjectMatch MatchId=\"urn:oasis:names:tc:xacml:1.0:function:string-equal\">\n");
        out.write("<AttributeValue DataType=\"http://www.w3.org/2001/XMLSchema#string\">accessPDP</AttributeValue>\n");
        out.write("<SubjectAttributeDesignator SubjectCategory=\"urn:oasis:names:tc:xacml:1.0:subject-category:recipient-subject\" AttributeId=\"urn:oasis:names:tc:xacml:1.0:subject-category:subject-id\" DataType=\"http://www.w3.org/2001/XMLSchema#string\" />\n");
        out.write("</SubjectMatch>\n");
        out.write("</Subject>\n");
        out.write("</Subjects>\n");
        out.write("<Actions>\n");
        out.write("<Action>\n");
        out.write("<ActionMatch MatchId=\"urn:oasis:names:tc:xacml:1.0:function:string-equal\">\n");
        out.write("<AttributeValue DataType=\"http://www.w3.org/2001/XMLSchema#string\">enableRole</AttributeValue>\n");
        out.write("<ActionAttributeDesignator AttributeId=\"urn:oasis:names:tc:xacml:1.0:action:action-id\" DataType=\"http://www.w3.org/2001/XMLSchema#string\" />\n");
        out.write("</ActionMatch>\n");
        out.write("</Action>\n");
        out.write("</Actions>\n");
        out.write("</Target>\n");
        int ruleId = 0;
        do {
            if (!line.contains("enable") && !line.contains("disable")) continue;
            out.write(this.processEnableRule(line, ruleId++));
        } while ((line = buffR.readLine()) != null);
        out.write("</Policy>\n");
        out.close();
    }

    private String processEnableRule(String rule, int ruleId) {
        String conditionsPart = rule.substring(rule.indexOf("(") + 1, rule.indexOf(")"));
        String[] conditions = conditionsPart.split(",");
        String roleStatusPart = rule.substring(rule.indexOf(")") + 1, rule.indexOf(">") + 1);
        if (roleStatusPart.indexOf(",") < roleStatusPart.indexOf("<")) {
            roleStatusPart = roleStatusPart.substring(roleStatusPart.indexOf(",") + 1);
        }
        int rulePrios = 0;
        if (roleStatusPart.contains(":")) {
            String[] roleStatusDef = roleStatusPart.split(":");
            rulePrios = Integer.parseInt(roleStatusDef[0].trim());
            roleStatusPart = roleStatusDef[1];
        }
        String roleName = roleStatusPart.substring(0, roleStatusPart.indexOf("<")).trim();
        StringTokenizer st = new StringTokenizer(roleName);
        st.nextToken();
        roleName = st.nextToken();
        String roleParamsDef = roleStatusPart.substring(roleStatusPart.indexOf("<") + 1, roleStatusPart.indexOf(">"));
        String[] roleParams = roleParamsDef.split(",");
        if (conditions.length != 3) {
            System.out.println("Syntax ERROR. " + conditionsPart + ": (TimeCond,SpaceCond,EventCond) needed");
            System.exit(-1);
        }
        String ret = "\n<Rule RuleId= \"urn:oasis:names:tc:xacml:2.0:example:rule" + ruleId + "\"";
        ret = rule.contains("enable") ? String.valueOf(ret) + " Effect=\"Permit\"" : String.valueOf(ret) + " Effect=\"Deny\"";
        ret = String.valueOf(ret) + " Priority=\"" + rulePrios + "\">\n";
        ret = String.valueOf(ret) + "<Description>" + rule.replace("<", "(").replace(">", ")") + "</Description>\n";
        ret = String.valueOf(ret) + "<Target>\n";
        ret = String.valueOf(ret) + "<Resources>\n";
        ret = String.valueOf(ret) + "<Resource>\n";
        ret = roleParamsDef.contains("Any") ? String.valueOf(ret) + "<ResourceMatch MatchId=\"urn:my:function:role:is-instance\">\n" : String.valueOf(ret) + "<ResourceMatch MatchId=\"urn:my:function:role:same-instance\">\n";
        ret = String.valueOf(ret) + "<AttributeValue DataType=\"urn:my:dataType:role\">\n";
        ret = String.valueOf(ret) + "<RoleName>urn:example:role-values:" + roleName + "</RoleName>\n";
        if (roleParams.length == 1 && roleParams[0].contentEquals("")) {
            ret = String.valueOf(ret) + "<RoleParams Number=\"0\" />\n";
        } else {
            ret = String.valueOf(ret) + "<RoleParams>\n";
            RoleTemplate rt = Policy_Translator.getDefinedTemplate(Policy_Translator.buildMapName(roleName, roleParams));
            if (rt == null) {
                System.out.println("ERROR. " + rule + ": missing definition for role '" + roleName + "<" + roleParamsDef + ">'");
                System.exit(-1);
            }
            List<String> params = rt.getParams();
            int i = 0;
            while (i < params.size()) {
                ret = roleParams[i].trim().contentEquals("Any") ? String.valueOf(ret) + "<Param Name=\"" + params.get(i) + "\" DataType=\"http://www.w3.org/2001/XMLSchema#string\" />\n" : String.valueOf(ret) + "<Param Name=\"" + params.get(i) + "\" DataType=\"http://www.w3.org/2001/XMLSchema#string\">" + roleParams[i] + "</Param>\n";
                ++i;
            }
            ret = String.valueOf(ret) + "</RoleParams>\n";
        }
        ret = String.valueOf(ret) + "</AttributeValue>\n";
        ret = String.valueOf(ret) + "<ResourceAttributeDesignator AttributeId=\"urn:oasis:names:tc:xacml:1.0:resource:resource-id\" DataType=\"urn:my:dataType:role\" />\n";
        ret = String.valueOf(ret) + "</ResourceMatch>\n";
        ret = String.valueOf(ret) + "</Resource>\n";
        ret = String.valueOf(ret) + "</Resources>\n";
        ret = String.valueOf(ret) + "</Target>\n";
        int numConditions = 0;
        String tcond = "";
        if (!conditions[0].contains("AnyTime")) {
            ++numConditions;
            TimeExpression te = this.timeExps.get(conditions[0].trim());
            if (te == null) {
                System.out.println("ERROR. " + rule + ": missing definition for time expression '" + conditions[0].trim() + "'");
                System.exit(-1);
            }
            tcond = "<Apply FunctionId=\"urn:my:function:time:inside\">\n";
            tcond = String.valueOf(tcond) + "<Apply FunctionId=\"urn:oasis:names:tc:xacml:1.0:function:dateTime-one-and-only\">\n";
            tcond = String.valueOf(tcond) + "<SubjectAttributeDesignator AttributeId=\"urn:oasis:names:tc:xacml:1.0:subject:request-time\" DataType=\"http://www.w3.org/2001/XMLSchema#dateTime\" />\n";
            tcond = String.valueOf(tcond) + "</Apply>\n";
            tcond = String.valueOf(tcond) + te.encode();
            tcond = String.valueOf(tcond) + "</Apply>\n";
        }
        String scond = "";
        if (!conditions[1].contains("AnyPlace")) {
            String[] spatialCond;
            ++numConditions;
            boolean logicalLoc = true;
            if (conditions[1].contains(":") && ((spatialCond = conditions[1].split(":"))[1].trim().contentEquals("locationType") || spatialCond[1].trim().contentEquals("lt"))) {
                logicalLoc = false;
                conditions[1] = spatialCond[0].trim();
            }
            scond = logicalLoc ? "<Apply FunctionId=\"urn:my:function:spatial:point-within-location-logical\">\n" : "<Apply FunctionId=\"urn:my:function:spatial:point-within-location-type\">\n";
            scond = String.valueOf(scond) + "<AttributeValue DataType=\"http://www.w3.org/2001/XMLSchema#string\">" + conditions[1].trim() + "</AttributeValue>\n";
            scond = String.valueOf(scond) + "<Apply FunctionId=\"urn:my:function:spatial:geometryAttribute-one-and-only\">\n";
            scond = String.valueOf(scond) + "<SubjectAttributeDesignator AttributeId=\"urn:my:subject:position-coord\" DataType=\"urn:ogc:def:dataType:geoxacml:1.0:geometry\" />\n";
            scond = String.valueOf(scond) + "</Apply>\n";
            scond = String.valueOf(scond) + "</Apply>\n";
        }
        String econd = "";
        if (!conditions[2].contains("AnyEvent")) {
            ++numConditions;
            econd = "<Apply FunctionId=\"urn:my:function:event:visible-at\">\n";
            econd = String.valueOf(econd) + "<AttributeValue DataType=\"http://www.w3.org/2001/XMLSchema#string\">" + conditions[2].trim() + "</AttributeValue>\n";
            econd = String.valueOf(econd) + "<Apply FunctionId=\"urn:my:function:spatial:geometryAttribute-one-and-only\">\n";
            econd = String.valueOf(econd) + "<SubjectAttributeDesignator AttributeId=\"urn:my:subject:position-coord\" DataType=\"urn:ogc:def:dataType:geoxacml:1.0:geometry\" />\n";
            econd = String.valueOf(econd) + "</Apply>\n";
            econd = String.valueOf(econd) + "<Apply FunctionId=\"urn:oasis:names:tc:xacml:1.0:function:string-one-and-only\">\n";
            econd = String.valueOf(econd) + "<SubjectAttributeDesignator AttributeId=\"urn:oasis:names:tc:xacml:1.0:subject-category:subject-id\" DataType=\"http://www.w3.org/2001/XMLSchema#string\" />\n";
            econd = String.valueOf(econd) + "</Apply>\n";
            econd = String.valueOf(econd) + "</Apply>\n";
        }
        if (numConditions >= 1) {
            ret = String.valueOf(ret) + "<Condition>\n";
            if (numConditions >= 2) {
                ret = String.valueOf(ret) + "<Apply FunctionId=\"urn:oasis:names:tc:xacml:1.0:function:and\">\n";
            }
            ret = String.valueOf(ret) + tcond + scond + econd;
            if (numConditions >= 2) {
                ret = String.valueOf(ret) + "</Apply>\n";
            }
            ret = String.valueOf(ret) + "</Condition>\n";
        }
        ret = String.valueOf(ret) + "</Rule>\n";
        return ret;
    }

    public static void main(String[] args) throws IOException {
        if (args.length == 0 || args.length > 1) {
            System.out.println("usage: policy_translator path_to_policy_file");
            System.exit(-1);
        }
        Policy_Translator pTrans = new Policy_Translator();
        try {
            pTrans.processPolicyFile(args[0]);
            pTrans.writeRolePolicy();
            System.out.println("Policy files succesfully created:");
            System.out.println("->" + pTrans.path + "/enablingPolicy");
            System.out.println("->" + pTrans.path + "/policy");
        }
        catch (FileNotFoundException e) {
            System.out.println("File Not Found.");
            System.exit(-1);
        }
    }
}

