/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.translator;

import com.sun.xacml.translator.Policy_Translator;
import com.sun.xacml.translator.RoleTemplate;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;

public class Priviledge {
    private String operation;
    private String objCat;
    private List<String> exp;
    private RoleTemplate role;

    public Priviledge(String op, String cat, RoleTemplate rt) {
        this.operation = op;
        this.objCat = cat;
        this.exp = new LinkedList<String>();
        this.role = rt;
    }

    public void parseExpression(String expr) {
        StringTokenizer st = new StringTokenizer(expr);
        String temp = "";
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            if (tok.compareToIgnoreCase("and") != 0) {
                temp = String.valueOf(temp) + " " + tok;
                continue;
            }
            this.exp.add(temp.trim());
            temp = "";
        }
        if (!(temp = temp.trim()).contentEquals("") && !temp.equalsIgnoreCase("true")) {
            this.exp.add(temp.trim());
        }
    }

    public static Priviledge[] processPriviledge(String priv, RoleTemplate rt) {
        String[] elements;
        int delimPos1 = priv.indexOf("(");
        if (delimPos1 > -1) {
            String privDef = priv.substring(delimPos1 + 1, priv.lastIndexOf(")"));
            elements = privDef.split(",");
        } else {
            elements = new String[]{priv};
        }
        if (elements.length == 1) {
            String roleParamsDef;
            String[] roleParams;
            String roleName;
            String roleKey;
            RoleTemplate roleT;
            int tokenPos = elements[0].indexOf("<");
            if (tokenPos < 0) {
                System.out.println("ERROR. " + elements[0] + ": expected '<'");
                System.exit(-1);
            }
            if ((roleT = Policy_Translator.getDefinedTemplate(roleKey = Policy_Translator.buildMapName(roleName = elements[0].substring(0, tokenPos).trim(), roleParams = (roleParamsDef = elements[0].substring(tokenPos + 1, elements[0].indexOf(">"))).split(",")))) == null) {
                System.out.println("ERROR. " + elements[0] + ": undefined role '" + roleName + "'");
                System.exit(-1);
            }
            List<Priviledge> perms = roleT.getPerms();
            Priviledge[] privs = new Priviledge[perms.size()];
            int i = 0;
            while (i < perms.size()) {
                Priviledge[] p = Priviledge.processPriviledge(perms.get(i).toString(), roleT);
                privs[i] = p[0];
                ++i;
            }
            return privs;
        }
        Priviledge[] privs = new Priviledge[1];
        Priviledge newPriv = new Priviledge(elements[0].trim(), elements[1].trim(), rt);
        String expression = elements[2];
        if (elements.length > 3) {
            int i = 3;
            while (i < elements.length) {
                expression = String.valueOf(expression) + "," + elements[i];
                ++i;
            }
        }
        newPriv.parseExpression(expression);
        privs[0] = newPriv;
        return privs;
    }

    private void writeValueMatch(BufferedWriter out, String cond) throws IOException {
        out.write("<Apply FunctionId=\"urn:oasis:names:tc:xacml:1.0:function:string-equal\">\n");
        int parPosBegin = cond.indexOf("(");
        int parPosEnd = cond.indexOf(")");
        String varsDef = cond.substring(parPosBegin + 1, parPosEnd);
        String[] vars = varsDef.split(",");
        if (vars.length != 2) {
            System.out.println("ERROR. " + this.toString() + ": ValueMatch needs 2 parameters");
            System.exit(-1);
        }
        int i = 0;
        while (i < vars.length) {
            String[] varDef = vars[i].split(":");
            if (varDef.length != 2) {
                System.out.println("ERROR. " + vars[i] + ": Malformed parameter. (Valid format is 'type:name')");
                System.exit(-1);
            }
            out.write("<Apply FunctionId=\"urn:oasis:names:tc:xacml:1.0:function:string-one-and-only\">\n");
            if (varDef[0].equalsIgnoreCase("property")) {
                out.write("<ResourceAttributeDesignator AttributeId=\"urn:my:resource:property:" + varDef[1].trim() + "\" DataType=\"http://www.w3.org/2001/XMLSchema#string\" />\n");
            } else if (varDef[0].equalsIgnoreCase("parameter")) {
                List<String> params = this.role.getParams();
                boolean declared = false;
                for (String param : params) {
                    if (!param.equalsIgnoreCase(varDef[1])) continue;
                    declared = true;
                    break;
                }
                if (!declared) {
                    System.out.println("ERROR " + this.toString() + ". No parameter " + varDef[1].trim() + " in role definition: " + this.role.toStringWithoutPerms());
                    System.exit(-1);
                }
                out.write("<SubjectAttributeDesignator AttributeId=\"urn:my:parameter:" + varDef[1].trim() + "\" DataType=\"http://www.w3.org/2001/XMLSchema#string\" />\n");
            } else {
                System.out.println("ERROR. " + varDef[0] + ": Unknown type. (It should be 'property' or 'parameter')");
                System.exit(-1);
            }
            out.write("</Apply>\n");
            ++i;
        }
        out.write("</Apply>\n");
    }

    private void writeEventVisible(BufferedWriter out, String cond) throws IOException {
        String[] varDef;
        int parPosEnd;
        int parPosBegin = cond.indexOf("(");
        String varsDef = cond.substring(parPosBegin + 1, parPosEnd = cond.indexOf(")"));
        String[] vars = varsDef.split(",");
        if (vars.length != 1) {
            System.out.println("ERROR. " + this.toString() + ": EventVisible needs 1 parameter");
            System.exit(-1);
        }
        if ((varDef = vars[0].split(":")).length != 2) {
            System.out.println("ERROR. " + this.toString() + ": Malformed parameter. (Valid format is 'event:name')");
            System.exit(-1);
        }
        out.write("<Apply FunctionId=\"urn:my:function:event:visible-at\">\n");
        out.write("<AttributeValue DataType=\"http://www.w3.org/2001/XMLSchema#string\">" + varDef[1].trim() + "</AttributeValue>\n");
        out.write("<Apply FunctionId=\"urn:my:function:spatial:geometryAttribute-one-and-only\">\n");
        out.write("<SubjectAttributeDesignator AttributeId=\"urn:my:subject:position-coord\" DataType=\"urn:ogc:def:dataType:geoxacml:1.0:geometry\" />\n");
        out.write("</Apply>\n");
        out.write("<Apply FunctionId=\"urn:oasis:names:tc:xacml:1.0:function:string-one-and-only\">\n");
        out.write("<SubjectAttributeDesignator AttributeId=\"urn:oasis:names:tc:xacml:1.0:subject-category:subject-id\" DataType=\"http://www.w3.org/2001/XMLSchema#string\" />\n");
        out.write("</Apply>\n");
        out.write("</Apply>\n");
    }

    public void writeEventVisibleIn(BufferedWriter out, String cond) throws IOException {
        int parPosEnd;
        String applyStr = "";
        String eventStr = "";
        String parameterStr = "";
        int parPosBegin = cond.indexOf("(");
        String varsDef = cond.substring(parPosBegin + 1, parPosEnd = cond.indexOf(")"));
        String[] vars = varsDef.split(",");
        if (vars.length != 2) {
            System.out.println("ERROR. " + this.toString() + ": EventVisibleIn needs 2 parameters");
            System.exit(-1);
        }
        int i = 0;
        while (i < vars.length) {
            String[] varDef = vars[i].split(":");
            if (varDef.length != 2) {
                System.out.println("ERROR. " + vars[i] + ": Malformed parameter. (Valid format is 'type:name')");
                System.exit(-1);
            }
            applyStr = "<Apply FunctionId=\"urn:my:function:event:visible-in\">\n";
            if (varDef[0].equalsIgnoreCase("event")) {
                eventStr = "<AttributeValue DataType=\"http://www.w3.org/2001/XMLSchema#string\">" + varDef[1].trim() + "</AttributeValue>\n";
            } else if (varDef[0].equalsIgnoreCase("parameter")) {
                List<String> params = this.role.getParams();
                boolean declared = false;
                for (String param : params) {
                    if (!param.equalsIgnoreCase(varDef[1])) continue;
                    declared = true;
                    break;
                }
                if (!declared) {
                    System.out.println("ERROR " + this.toString() + ". No parameter " + varDef[1].trim() + " in role definition: " + this.role.toStringWithoutPerms());
                    System.exit(-1);
                }
                parameterStr = "<Apply FunctionId=\"urn:oasis:names:tc:xacml:1.0:function:string-one-and-only\">\n";
                parameterStr = String.valueOf(parameterStr) + "<SubjectAttributeDesignator AttributeId=\"urn:my:parameter:" + varDef[1].trim() + "\" DataType=\"http://www.w3.org/2001/XMLSchema#string\" />\n";
                parameterStr = String.valueOf(parameterStr) + "</Apply>\n";
            } else {
                System.out.println("ERROR. " + varDef[0] + ": Unknown type. (It should be 'event' or 'parameter')");
                System.exit(-1);
            }
            ++i;
        }
        applyStr = String.valueOf(applyStr) + eventStr + parameterStr;
        applyStr = String.valueOf(applyStr) + "<Apply FunctionId=\"urn:oasis:names:tc:xacml:1.0:function:string-one-and-only\">\n";
        applyStr = String.valueOf(applyStr) + "<SubjectAttributeDesignator AttributeId=\"urn:oasis:names:tc:xacml:1.0:subject:subject-id\" DataType=\"http://www.w3.org/2001/XMLSchema#string\" />\n";
        applyStr = String.valueOf(applyStr) + "</Apply>\n";
        applyStr = String.valueOf(applyStr) + "</Apply>\n";
        out.write(applyStr);
    }

    public void writeEventGeneratedBy(BufferedWriter out, String cond) throws IOException {
        int parPosEnd;
        String applyStr = "";
        String eventStr = "";
        String propertyStr = "";
        int parPosBegin = cond.indexOf("(");
        String varsDef = cond.substring(parPosBegin + 1, parPosEnd = cond.indexOf(")"));
        String[] vars = varsDef.split(",");
        if (vars.length != 2) {
            System.out.println("ERROR. " + this.toString() + ": EventGeneratedBy needs 2 parameters");
            System.exit(-1);
        }
        int i = 0;
        while (i < vars.length) {
            String[] varDef = vars[i].split(":");
            if (varDef.length != 2) {
                System.out.println("ERROR. " + vars[i] + ": Malformed parameter. (Valid format is 'type:name')");
                System.exit(-1);
            }
            applyStr = "<Apply FunctionId=\"urn:my:function:event:generated-by-and-visible-at\">\n";
            if (varDef[0].equalsIgnoreCase("event")) {
                eventStr = "<AttributeValue DataType=\"http://www.w3.org/2001/XMLSchema#string\">" + varDef[1].trim() + "</AttributeValue>\n";
            } else if (varDef[0].equalsIgnoreCase("property")) {
                propertyStr = "<Apply FunctionId=\"urn:oasis:names:tc:xacml:1.0:function:string-one-and-only\">\n";
                propertyStr = String.valueOf(propertyStr) + "<ResourceAttributeDesignator AttributeId=\"urn:my:resource:property:" + varDef[1].trim() + "\" DataType=\"http://www.w3.org/2001/XMLSchema#string\"/>\n";
                propertyStr = String.valueOf(propertyStr) + "</Apply>\n";
            } else {
                System.out.println("ERROR. " + varDef[0] + ": Unknown type. (It should be 'event' or 'parameter')");
                System.exit(-1);
            }
            ++i;
        }
        applyStr = String.valueOf(applyStr) + propertyStr + eventStr;
        applyStr = String.valueOf(applyStr) + "<Apply FunctionId=\"urn:my:function:spatial:geometryAttribute-one-and-only\">\n";
        applyStr = String.valueOf(applyStr) + "<SubjectAttributeDesignator AttributeId=\"urn:my:subject:position-coord\" DataType=\"urn:ogc:def:dataType:geoxacml:1.0:geometry\" />\n";
        applyStr = String.valueOf(applyStr) + "</Apply>\n";
        applyStr = String.valueOf(applyStr) + "<Apply FunctionId=\"urn:oasis:names:tc:xacml:1.0:function:string-one-and-only\">\n";
        applyStr = String.valueOf(applyStr) + "<SubjectAttributeDesignator AttributeId=\"urn:oasis:names:tc:xacml:1.0:subject:subject-id\" DataType=\"http://www.w3.org/2001/XMLSchema#string\" />\n";
        applyStr = String.valueOf(applyStr) + "</Apply>\n";
        applyStr = String.valueOf(applyStr) + "</Apply>\n";
        out.write(applyStr);
    }

    public void writeAreNear(BufferedWriter out, String cond) throws IOException {
        int parPosEnd;
        int parPosBegin = cond.indexOf("(");
        String varsDef = cond.substring(parPosBegin + 1, parPosEnd = cond.indexOf(")"));
        String[] vars = varsDef.split(",");
        if (vars.length > 1) {
            System.out.println("ERROR. " + this.toString() + ": AreNear needs 0 or 1 parameter");
            System.exit(-1);
        }
        out.write("<Apply FunctionId=\"urn:my:function:spatial:are-near\">\n");
        out.write("<Apply FunctionId=\"urn:my:function:spatial:geometryAttribute-one-and-only\">\n");
        out.write("<SubjectAttributeDesignator AttributeId=\"urn:my:subject:position-coord\" DataType=\"urn:ogc:def:dataType:geoxacml:1.0:geometry\"/>\n");
        out.write("</Apply>\n");
        if (vars[0].contentEquals("")) {
            out.write("<Apply FunctionId=\"urn:my:function:spatial:geometryAttribute-one-and-only\">\n");
            out.write("<ResourceAttributeDesignator AttributeId=\"urn:my:resource:position-coord\" DataType=\"urn:ogc:def:dataType:geoxacml:1.0:geometry\"/>\n");
            out.write("</Apply>\n");
        } else {
            String[] varDef = vars[0].split(":");
            if (varDef[0].equalsIgnoreCase("property")) {
                out.write("<Apply FunctionId=\"urn:my:function:spatial:geometryAttribute-one-and-only\">\n");
                out.write("<ResourceAttributeDesignator AttributeId=\"urn:my:resource:property:" + varDef[1].trim() + "\" DataType=\"http://www.w3.org/2001/XMLSchema#string\"/>\n");
                out.write("</Apply>\n");
            } else {
                System.out.println("ERROR. " + varDef[0] + ": Unknown type. (It should be 'property')");
                System.exit(-1);
            }
        }
        out.write("</Apply>\n");
    }

    public void writePositionIn(BufferedWriter out, String cond) throws IOException {
        int parPosEnd;
        String parameterStr = "";
        String propertyStr = "";
        int parPosBegin = cond.indexOf("(");
        String varsDef = cond.substring(parPosBegin + 1, parPosEnd = cond.indexOf(")"));
        String[] vars = varsDef.split(",");
        if (vars.length != 2) {
            System.out.println("ERROR. " + this.toString() + ": PositionIn needs 2 parameters");
            System.exit(-1);
        }
        String[] stringArray = vars;
        int n = vars.length;
        int n2 = 0;
        while (n2 < n) {
            String var = stringArray[n2];
            String[] varDefinition = var.split(":");
            if (varDefinition.length != 2) {
                System.out.println("ERROR. " + var + ": Malformed parameter. (Valid format is 'type:name')");
                System.exit(-1);
            }
            String varDef = varDefinition[1].trim();
            if (varDefinition[0].trim().equalsIgnoreCase("property")) {
                propertyStr = varDef;
            } else if (varDefinition[0].trim().equalsIgnoreCase("parameter")) {
                parameterStr = varDef;
            } else {
                System.out.println("ERROR. " + var + ": Unknown type. (It should be 'property' or 'parameter')");
                System.exit(-1);
            }
            ++n2;
        }
        out.write("<Apply FunctionId=\"urn:my:function:spatial:point-within-location-logical\">\n");
        out.write("<Apply FunctionId=\"urn:oasis:names:tc:xacml:1.0:function:string-one-and-only\">\n");
        out.write("<SubjectAttributeDesignator AttributeId=\"urn:my:parameter:" + parameterStr + "\" DataType=\"http://www.w3.org/2001/XMLSchema#string\" />\n");
        out.write("</Apply>\n");
        out.write("<Apply FunctionId=\"urn:my:function:spatial:geometryAttribute-one-and-only\">\n");
        out.write("<ResourceAttributeDesignator AttributeId=\"urn:my:resource:property:" + propertyStr + "\" DataType=\"urn:ogc:def:dataType:geoxacml:1.0:geometry\"/>\n");
        out.write("</Apply>\n");
        out.write("</Apply>\n");
    }

    public void writeCondition(BufferedWriter out) throws IOException {
        if (this.exp.size() > 0) {
            out.write("<Condition>\n");
        }
        if (this.exp.size() > 1) {
            out.write("<Apply FunctionId=\"urn:oasis:names:tc:xacml:1.0:function:and\">\n");
        }
        for (String cond : this.exp) {
            if (cond.contains("ValueMatch")) {
                this.writeValueMatch(out, cond);
                continue;
            }
            if (cond.contains("EventVisibleIn")) {
                this.writeEventVisibleIn(out, cond);
                continue;
            }
            if (cond.contains("EventVisible")) {
                this.writeEventVisible(out, cond);
                continue;
            }
            if (cond.contains("EventGeneratedBy")) {
                this.writeEventGeneratedBy(out, cond);
                continue;
            }
            if (cond.contains("AreNear")) {
                this.writeAreNear(out, cond);
                continue;
            }
            if (cond.contains("PositionIn")) {
                this.writePositionIn(out, cond);
                continue;
            }
            System.out.println("ERROR. '" + cond + "': unknown function");
            System.exit(-1);
        }
        if (this.exp.size() > 1) {
            out.write("</Apply>\n");
        }
        if (this.exp.size() > 0) {
            out.write("</Condition>\n");
        }
    }

    public void write(BufferedWriter out) throws IOException {
        out.write("<Rule RuleId=\"" + this.buildRuleId() + "\" Effect=\"Permit\">\n");
        out.write("<Target>\n");
        out.write("<Resources>\n");
        out.write("<Resource>\n");
        out.write("<ResourceMatch MatchId=\"urn:oasis:names:tc:xacml:1.0:function:anyURI-equal\">\n");
        out.write("<AttributeValue DataType=\"http://www.w3.org/2001/XMLSchema#anyURI\">urn:example:resource-categories:" + this.objCat + "</AttributeValue>\n");
        out.write("<ResourceAttributeDesignator AttributeId=\"urn:example:resource:category-id\" DataType=\"http://www.w3.org/2001/XMLSchema#anyURI\"/>\n");
        out.write("</ResourceMatch>\n");
        out.write("</Resource>\n");
        out.write("</Resources>\n");
        out.write("<Actions>\n");
        out.write("<Action>\n");
        out.write("<ActionMatch MatchId=\"urn:oasis:names:tc:xacml:1.0:function:string-equal\">\n");
        out.write("<AttributeValue DataType=\"http://www.w3.org/2001/XMLSchema#string\">" + this.operation + "</AttributeValue>\n");
        out.write("<ActionAttributeDesignator AttributeId=\"urn:oasis:names:tc:xacml:1.0:action:action-id\" DataType=\"http://www.w3.org/2001/XMLSchema#string\"/>\n");
        out.write("</ActionMatch>\n");
        out.write("</Action>\n");
        out.write("</Actions>\n");
        out.write("</Target>\n");
        this.writeCondition(out);
        out.write("</Rule>\n");
    }

    private String buildRuleId() {
        String Id = this.operation;
        Id = String.valueOf(Id) + ":" + this.objCat;
        if (this.exp.size() > 0) {
            Id = String.valueOf(Id) + ":";
            int i = 0;
            while (i < this.exp.size() - 1) {
                Id = String.valueOf(Id) + this.exp.get(i) + "_and_";
                ++i;
            }
            Id = String.valueOf(Id) + this.exp.get(this.exp.size() - 1);
        }
        return Id;
    }

    public String toString() {
        String Id = "(" + this.operation;
        Id = String.valueOf(Id) + "," + this.objCat;
        if (this.exp.size() > 0) {
            Id = String.valueOf(Id) + ",";
            int i = 0;
            while (i < this.exp.size() - 1) {
                Id = String.valueOf(Id) + this.exp.get(i) + " and ";
                ++i;
            }
            Id = String.valueOf(Id) + this.exp.get(this.exp.size() - 1);
        } else {
            Id = String.valueOf(Id) + ",true";
        }
        return String.valueOf(Id) + ")";
    }
}

