/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.translator;

import com.sun.xacml.translator.Policy_Translator;
import com.sun.xacml.translator.Priviledge;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

public class RoleTemplate {
    private String name;
    private List<String> params;
    private List<Priviledge> perms;

    public RoleTemplate(String name) {
        this.name = name;
        this.params = new LinkedList<String>();
        this.perms = new LinkedList<Priviledge>();
    }

    public String getName() {
        return this.name;
    }

    public List<String> getParams() {
        return this.params;
    }

    public List<Priviledge> getPerms() {
        return this.perms;
    }

    public static RoleTemplate parseDefinition(String def) {
        String[] roleDef = def.split("=");
        int parPos = roleDef[0].indexOf("<");
        if (parPos < 0) {
            System.out.println("Syntax ERROR. " + roleDef[0] + ": missing '<'");
            System.exit(-1);
        }
        String roleName = roleDef[0].substring(0, parPos);
        RoleTemplate newRole = new RoleTemplate(roleName.trim());
        String varsDef = roleDef[0].substring(parPos + 1, roleDef[0].indexOf(">"));
        String[] vars = varsDef.split(",");
        int i = 0;
        while (i < vars.length) {
            String trimmedVar = vars[i].trim();
            if (!trimmedVar.contentEquals("")) {
                newRole.params.add(trimmedVar);
            }
            ++i;
        }
        String permsDef = roleDef[1].substring(roleDef[1].indexOf("(") + 1, roleDef[1].lastIndexOf(")"));
        String[] perms = permsDef.split(";");
        int i2 = 0;
        while (i2 < perms.length) {
            Priviledge[] newPrivs;
            Priviledge[] priviledgeArray = newPrivs = Priviledge.processPriviledge(perms[i2], newRole);
            int n = newPrivs.length;
            int n2 = 0;
            while (n2 < n) {
                Priviledge priv = priviledgeArray[n2];
                newRole.perms.add(priv);
                ++n2;
            }
            ++i2;
        }
        return newRole;
    }

    public void write(BufferedWriter out) throws IOException {
        out.write("<Policy xmlns=\"urn:oasis:names:tc:xacml:2.0:policy:schema:os\" PolicyId=\"rolePS:" + Policy_Translator.buildMapName(this) + "\"" + " RuleCombiningAlgId=\"urn:oasis:names:tc:xacml:1.0:rule-combining-algorithm:permit-overrides\">\n");
        out.write("<Target>\n");
        out.write("<Subjects>\n");
        out.write("<Subject>\n");
        out.write("<SubjectMatch MatchId=\"urn:my:function:role:is-instance\">\n");
        out.write("<AttributeValue DataType=\"urn:my:dataType:role\">\n");
        out.write("<RoleName>urn:example:role-values:" + this.getName() + "</RoleName>\n");
        List<String> params = this.getParams();
        if (params.size() == 0) {
            out.write("<RoleParams Number = \"0\" />");
        } else {
            out.write("<RoleParams>\n");
        }
        for (String param : params) {
            out.write("<Param Name=\"" + param + "\" DataType=\"http://www.w3.org/2001/XMLSchema#string\" />\n");
        }
        if (params.size() != 0) {
            out.write("</RoleParams>\n");
        }
        out.write("</AttributeValue>\n");
        out.write("<SubjectAttributeDesignator AttributeId=\"urn:oasis:names:tc:xacml:2.0:subject:role\" DataType=\"urn:my:dataType:role\" />\n");
        out.write("</SubjectMatch>\n");
        out.write("</Subject>\n");
        out.write("</Subjects>\n");
        out.write("</Target>\n");
        List<Priviledge> privs = this.getPerms();
        for (Priviledge priv : privs) {
            priv.write(out);
        }
        out.write("</Policy>\n");
    }

    public String toStringWithoutPerms() {
        String s = String.valueOf(this.name) + "<";
        List<String> params = this.params;
        int i = 0;
        while (i < params.size() - 1) {
            String param = params.get(i);
            s = String.valueOf(s) + param + ",";
            ++i;
        }
        s = String.valueOf(s) + params.get(params.size() - 1) + ">";
        return s;
    }
}

