/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.translator;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;

public class TimeExpression {
    private String name;
    private Date iStart = null;
    private Date iEnd = null;
    private static Map<String, Integer> validCals = new HashMap<String, Integer>();
    private Map<String, String> cStart = null;
    private String cEndType = "";
    private int cEndLength = -1;

    static {
        validCals.put("Hours", new Integer(4));
        validCals.put("Days", new Integer(3));
        validCals.put("Weeks", new Integer(2));
        validCals.put("Months", new Integer(1));
        validCals.put("Years", new Integer(0));
    }

    public TimeExpression(String tExpName, Date intervalS, Date intervalE) {
        this.name = tExpName;
        this.iStart = intervalS;
        this.iEnd = intervalE;
    }

    public TimeExpression(String tExpName, Date intervalS, Date intervalE, Map<String, String> calS, String calEName, int calELen) {
        this.name = tExpName;
        this.iStart = intervalS;
        this.iEnd = intervalE;
        this.cStart = calS;
        this.cEndType = calEName;
        this.cEndLength = calELen;
    }

    public static TimeExpression processTimeExp(String line) {
        String pExpDef;
        String[] expDef;
        StringTokenizer st;
        if (!line.contains("=")) {
            System.out.println("Syntax ERROR. " + line + ": valid format 'TimeExp exp_name = (exp_def)'");
            System.exit(-1);
        }
        if ((st = new StringTokenizer((expDef = line.split("="))[0])).countTokens() != 2) {
            System.out.println("Syntax ERROR. " + expDef[0] + ": valid format 'TimeExp exp_name'");
            System.exit(-1);
        }
        st.nextToken();
        String expName = st.nextToken().trim();
        String timeExpDef = expDef[1].substring(expDef[1].indexOf("(") + 1, expDef[1].lastIndexOf(")"));
        String[] teCouple = timeExpDef.split(",");
        Date iStart = null;
        Date iEnd = null;
        if (!teCouple[0].trim().contentEquals("")) {
            String intervalDef = teCouple[0].substring(teCouple[0].indexOf("(") + 1, teCouple[0].indexOf(")"));
            String[] interval = intervalDef.split(";");
            String iStartStr = interval[0].trim();
            String iEndStr = "";
            if (interval.length > 1) {
                iEndStr = interval[1].trim();
            }
            SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy HH:mm");
            if (!iStartStr.contentEquals("")) {
                try {
                    iStart = df.parse(iStartStr);
                }
                catch (ParseException e) {
                    System.out.println("Invalid date format. " + iStartStr + ": valid format 'dd/MM/yyyy HH:mm'");
                    System.exit(-1);
                }
            }
            if (!iEndStr.contentEquals("")) {
                try {
                    iEnd = df.parse(iEndStr);
                }
                catch (ParseException e) {
                    System.out.println("Invalid date format. " + iEndStr + ": valid format 'dd/MM/yyyy HH:mm'");
                    System.exit(-1);
                }
            }
        }
        if ((pExpDef = teCouple[1].trim()).contentEquals("")) {
            return new TimeExpression(expName, iStart, iEnd);
        }
        int operatorPos = pExpDef.indexOf(">");
        if (operatorPos < 0) {
            System.out.println("Syntax ERROR. " + pExpDef + ": missing operator '>'");
            System.exit(-1);
        }
        String[] pExp = pExpDef.split(">");
        String[] cals = pExp[0].split("\\+");
        String calName = "";
        TreeMap<String, String> calStart = new TreeMap<String, String>(new Comparator(){

            public int compare(Object arg0, Object arg1) {
                String o1 = (String)arg0;
                String o2 = (String)arg1;
                int diff = (Integer)validCals.get(o1) - (Integer)validCals.get(o2);
                return diff;
            }
        });
        int i = 0;
        while (i < cals.length) {
            String previousCalName = calName;
            String[] cal = cals[i].split("\\*");
            calName = cal[1].trim();
            if (validCals.get(calName) == null) {
                System.out.println("Syntax ERROR. " + cals[i] + ": unknown calendar '" + calName + "'");
                System.exit(-1);
            }
            if (!previousCalName.contentEquals("") && validCals.get(previousCalName) >= validCals.get(calName)) {
                System.out.println("Syntax ERROR. " + pExp[0] + ": " + calName + " is not a subcalendar of " + previousCalName);
                System.exit(-1);
            }
            String Oi = cal[0].substring(cal[0].indexOf("{") + 1, cal[0].indexOf("}"));
            String formattedOi = Oi.trim();
            formattedOi = formattedOi.replaceAll(";", ",");
            calStart.put(calName, formattedOi);
            ++i;
        }
        String[] calEndDef = pExp[1].split("\\*");
        String Oi = calEndDef[0].substring(calEndDef[0].indexOf("{") + 1, calEndDef[0].indexOf("}"));
        String calEndName = calEndDef[1].trim();
        if (validCals.get(calEndName) < validCals.get(calName)) {
            System.out.println("Syntax ERROR. " + pExpDef + ": " + calEndName + " is a calendar bigger than " + calName);
            System.exit(-1);
        }
        return new TimeExpression(expName, iStart, iEnd, calStart, calEndName, Integer.parseInt(Oi.trim()));
    }

    public String getName() {
        return this.name;
    }

    public String encode() {
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy HH:mm");
        String ret = "<AttributeValue DataType=\"urn:my:periodic-expression\">\n";
        if (this.iStart != null || this.iEnd != null) {
            ret = String.valueOf(ret) + "<Interval DateFormat=\"dd/MM/yyyy HH:mm\">\n";
            if (this.iStart != null) {
                ret = String.valueOf(ret) + "<Start>" + df.format(this.iStart) + "</Start>\n";
            }
            if (this.iEnd != null) {
                ret = String.valueOf(ret) + "<End>" + df.format(this.iEnd) + "</End>\n";
            }
            ret = String.valueOf(ret) + "</Interval>\n";
        }
        if (this.cStart != null) {
            ret = String.valueOf(ret) + "<PeriodicExp>\n";
            for (String value : this.cStart.keySet()) {
                ret = String.valueOf(ret) + "<CalendarStart Type=\"" + value + "\">" + this.cStart.get(value) + "</CalendarStart>\n";
            }
            ret = String.valueOf(ret) + "<CalendarLength Type=\"" + this.cEndType + "\">" + this.cEndLength + "</CalendarLength>\n";
            ret = String.valueOf(ret) + "</PeriodicExp>\n";
        }
        ret = String.valueOf(ret) + "</AttributeValue>\n";
        return ret;
    }
}

