	program cmcgalfa

	parameter max=100
	dimension dx(max),wf(max),aif(max),depsdalfu(max),xi(max)
	data pig /3.141592654/
c----input------------------------------------------------------------
	open(10,File='velivolo.txt')
	read(10,*)
	read(10,*)
	read(10,*)
c xcg ed xac sono riferiti alla corda media
c aiw=iw; ait=it; alt=lt
	read(10,*) xcg
	read(10,*)
	read(10,*)
	read(10,*)
	read(10,*) S,b,cmedia,frecc,aiw
	read(10,*)
	read(10,*) cmacw,cla,alf0l,xac,alambda
	read(10,*)
	read(10,*)
	read(10,*)
	read(10,*) St,bt,cmediat,alt,frecct,ait
	read(10,*)
	read(10,*) cla2t,alambdat
	read(10,*)
	read(10,*)
	read(10,*)
	read(10,*)
	read(10,*)
	read(10,*)
	do i=1,13
		read(10,*) dum,dx(i),wf(i),aif(i)
	end do
	read(10,*)
	read(10,*)
	read(10,*) ak2k1
	read(10,*)
	do i=1,8
		read(10,*) dum,dum,dum,depsdalfu(i)
	end do
	do i=1,4
		read(10,*) dum,xi(i)
	end do
	close (10)
c----programma--------------------------------------------------------
	AR=b*b/S
	ARt=bt*bt/St
	M=0.
	call duetred(pig,frecc,AR,alambda,M,cla,claw)
	call duetred(pig,frecct,ARt,alambdat,M,cla2t,clat)
	call ala(xcg,cmacw,claw,alf0l,aiw,xac,cl0,cm0w,cmaw)
	call coda(pig,S,AR,cmedia,St,alt,clat,cl0,claw,aiw,ait,cm0t,cmat,
     + depsdalf,etah,Vh)
	call fuso(ak2k1,dx,wf,aif,depsdalfu,xi,S,cmedia,depsdalf,
     + alt,alf0l,cm0f,cmaf)
	call totale(cm0w,cmaw,cm0t,cmat,cm0f,cmaf,cm0,cma)
	call comblocc(xac,claw,cmaf,cmat,xnb)
c----output-----------------------------------------------------------
	open(11,File='rette.txt')
	write(11,*) 'Contributo della ala.'
	write(11,1) 'Cm0w=',cm0w,'Cmalfaw(1/deg)=',cmaw
	write(11,*)
	write(11,*) 'Contributo del piano di coda.'
	write(11,1) 'Cm0t=',cm0t,'Cmalfat(1/deg)=',cmat
	write(11,*)
	write(11,*) 'Contributo della fusoliera.'
	write(11,1) 'Cm0f=',cm0f,'Cmalfaf(1/deg)=',cmaf
	write(11,*)
	write(11,*) 'Velivolo completo.'
	write(11,1) 'Cm0=',cm0,'Cmalfa(1/deg)=',cma
	write(11,*)
	write(11,*) 'Posizione del punto neutro a comandi bloccati.'
	write(11,2) 'xn/cmedia=',xnb
	write(11,*)
 1	format(a18,f10.4)
 2	format(a18,f10.3)
	close (11)
	END
c----subroutine-------------------------------------------------------
	subroutine duetred(pig,frecc,AR,alambda,M,cla2,cla3)
c tangmez  la tangente della freccia calcolata ad 1/2c
c frecc va espresso in gradi
	tangmez=tan(frecc*pig/180.)-4./AR*(.5-.25)*(1.-alambda)/(1.+alambda)
c cla2  espresso in 1/deg	
	ak=cla2*90./pig**2
	beta=(1-M**2)**.5
c cla3  espresso in gradi
	cla3=pig**2/90.*AR/
     + (2.+(AR**2*beta**2/ak**2*(1.+tangmez**2/beta**2)+4.)**.5)
	end
	 
	subroutine ala(xcg,cmacw,claw,alf0l,aiw,xac,cl0,cm0w,cmaw)
	cl0=-claw*alf0l
	cm0w=cmacw+(cl0+claw*aiw)*(xcg-xac)
	cmaw=claw*(xcg-xac)
	end

	subroutine coda(pig,S,AR,cmedia,St,alt,clat,cl0,claw,aiw,ait,
     + cm0t,cmat,depsdalf,etah,Vh)
	Vh=St*alt/(S*cmedia)
	etah=1.
	eps0=360.*cl0/(pig**2*AR)
c claw deve essere espresso in 1/deg
	depsdalf=360.*claw/(pig**2*AR)
	cm0t=-etah*Vh*clat*(-eps0-aiw*depsdalf+ait)
	cmat=-etah*Vh*clat*(1.-depsdalf)
	end

	subroutine fuso(ak2k1,dx,wf,aif,depsdalfu,xi,S,cmedia,depsdalf,
     + alt,alf0l,cm0f,cmaf)
	parameter max=100
	dimension dx(max),wf(max),aif(max),depsdalfu(max),xi(max)
	sum=0.
	do i=1,13
		sum=sum+wf(i)**2*(alf0l+aif(i))*dx(i)
	end do
	cm0f=ak2k1/(36.5*S*cmedia)*sum
	
	sum=0.
	do i=1,8
		sum=sum+wf(i)**2*depsdalfu(9-i)*dx(i)
	end do

	sum1=0.
	alh=alt-.75*cmedia
	do i=1,4
		sum1=sum1+wf(i+9)**2*xi(i)/alh*(1-depsdalf)*dx(i+9)
	end do
	cmaf=(sum+sum1)/(36.5*S*cmedia)
	end

	subroutine totale(cm0w,cmaw,cm0t,cmat,cm0f,cmaf,cm0,cma)
	cm0=cm0w+cm0t+cm0f
	cma=cmaw+cmat+cmaf
	end

	subroutine comblocc(xac,claw,cmaf,cmat,xnb)
c xnb  in percentuale della corda media
	xnb=xac-(cmaf+cmat)/claw
	end
